/*
 * Decompiled with CFR 0.152.
 */
package biquaddesigner;

import biquaddesigner.BiQuadDesigner;
import biquaddesigner.BiQuadraticFilter;
import biquaddesigner.ComboBoxTextController;
import biquaddesigner.GraphPanel;
import biquaddesigner.TabPanelController;
import biquaddesigner.TextFieldController;
import biquaddesigner.ToggleButtonController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public final class BiQuadDesignerPanel
extends JPanel {
    boolean debug = false;
    List<String> filter_names = Arrays.asList("Lowpass", "Highpass", "Bandpass", "Notch", "Peak", "Lowshelf", "Highshelf");
    List<String> filter_tips = Arrays.asList("Gain has no effect, Q works", "Default Q setting = 70.7, gain has no effect", "Default Q setting = 70.7, gain has no effect", "Gain has no effect, Q works", "Gain and Q work", "Gain works, Q has no effect", "Gain works, Q has no effect");
    List<String> gain_vals = Arrays.asList("1", "2", "5", "10", "20", "50", "100");
    HashMap<String, Integer> filter_hash;
    HashMap<Integer, String> name_hash;
    HashMap<String, String> tips_hash;
    Object parent;
    GraphPanel gpanel;
    TextFieldController q;
    TextFieldController filter_gain;
    TextFieldController center_frequency;
    TextFieldController graph_start_frequency;
    TextFieldController graph_end_frequency;
    TextFieldController sample_rate;
    double y_axis_gain = 1.0;
    ComboBoxTextController filter_type;
    ToggleButtonController db_mode;
    TabPanelController selected_tab;
    Timer periodic_timer = null;
    int timer_period_ms = 250;
    BiQuadraticFilter filter = null;
    int type = -1;
    double v_q;
    double v_filter_gain;
    double v_y_axis_gain;
    double v_cf;
    double v_sr;
    double v_start;
    double v_end;
    double v_sr_old = -1.0;
    boolean v_dbmode = false;
    double[] constants;
    private ButtonGroup buttonGroup1;
    private JTextField cf_textfield;
    private JPanel control_panel;
    protected JButton copy_button;
    private JRadioButton db_radiobutton;
    private JButton defaults_button;
    private JPanel description_container;
    private JTextArea description_text;
    private JTextField endf_textfield;
    private JComboBox filter_type_combobox;
    private JTextField gain_textfield;
    private JPanel graph_control_panel;
    private JPanel graph_panel_tab;
    private JButton help_button;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JScrollPane jScrollPane1;
    private JRadioButton linear_radiobutton;
    protected JLabel mouse_pos_label;
    private JPanel panela;
    private JPanel panelb;
    private JTextField q_textfield;
    private JButton quit_button;
    private JTextField rate_textfield;
    private JTextField startf_textfield;
    private JTabbedPane tabbed_pane;

    public BiQuadDesignerPanel(Object p, String[] args) {
        this.parent = p;
        if (args.length > 0 && args[0].equals("-d")) {
            this.debug = true;
        }
        this.initComponents();
        this.quit_button.setVisible(this.parent instanceof JFrame);
        this.help_button.setVisible(this.parent instanceof JFrame);
        this.filter_hash = new HashMap<String, Integer>(){
            {
                this.put("Lowpass", 0);
                this.put("Highpass", 1);
                this.put("Bandpass", 2);
                this.put("Peak", 3);
                this.put("Notch", 4);
                this.put("Highshelf", 6);
                this.put("Lowshelf", 5);
            }
        };
        this.name_hash = new HashMap();
        for (String s : this.filter_hash.keySet()) {
            this.name_hash.put(this.filter_hash.get(s), s);
        }
        this.tips_hash = new HashMap();
        int i = 0;
        for (String s : this.filter_names) {
            this.tips_hash.put(s, this.filter_tips.get(i++));
        }
        this.filter = new BiQuadraticFilter();
        this.gpanel = new GraphPanel(this);
        this.graph_panel_tab.add((Component)this.gpanel, "Center");
        this.setup_controls();
        this.periodic_timer = new Timer();
        this.periodic_timer.scheduleAtFixedRate((TimerTask)new PeriodicEvents(), 500L, (long)this.timer_period_ms);
    }

    private void update_description() {
        if (this.filter != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Filter Description\n");
            String name = this.name_hash.get(this.filter.type);
            sb.append(String.format("   %-14s\n", "Type"));
            this.format_const(sb, "", name);
            sb.append(String.format("   %-14s\n", "Notes"));
            this.format_const(sb, "", this.tips_hash.get(name));
            sb.append(String.format("   %-14s\n", "Constants"));
            double[] constants = this.filter.constants();
            for (int i = 1; i < 6; ++i) {
                double v = constants[i - 1];
                String s = String.format("%s%d", i < 3 ? "a" : "b", i % 3);
                this.format_const(sb, s, v);
            }
            sb.append(String.format("   %-14s\n", "User Settings"));
            this.format_const(sb, "Q", this.q.get_dvalue());
            this.format_const(sb, "Filter Gain", this.filter_gain.get_dvalue());
            this.format_const(sb, "Center Freq. Hz", this.center_frequency.get_dvalue());
            this.format_const(sb, "Sample Rate", this.sample_rate.get_dvalue());
            sb.append(String.format("   %-14s\n", "Graph Settings"));
            this.format_const(sb, "Start Hz", this.graph_start_frequency.get_dvalue());
            this.format_const(sb, "End Hz", this.graph_end_frequency.get_dvalue());
            this.format_const(sb, "Display Mode", this.db_mode.get_value() ? "DB" : "Linear");
            sb.append("\nHome page: http://arachnoid.com/BiQuadDesigner");
            sb.append("\nCopyright (C) 2011, P. Lutus \u2014 http://arachnoid.com");
            this.description_text.setText(sb.toString());
        }
    }

    private void format_const(StringBuilder sb, String name, double v) {
        String s = String.format("%g", v);
        int p = s.indexOf(".");
        int n = p = p == -1 ? s.length() : p;
        while (p++ < 6) {
            s = " " + s;
        }
        sb.append(String.format("      %-16s = %s\n", name, s));
    }

    private void format_const(StringBuilder sb, String name, String v) {
        if (name.length() > 0) {
            sb.append(String.format("      %-16s = %s\n", name, v));
        } else {
            sb.append(String.format("      %4s\n", v));
        }
    }

    private void update_controls() {
        if (this.type == -1 || this.need_new_filter()) {
            this.new_filter();
        }
    }

    private void new_filter() {
        this.type = this.filter_hash.get(this.filter_type.get_value());
        this.v_q = this.q.get_dvalue();
        this.v_filter_gain = this.filter_gain.get_dvalue();
        this.v_y_axis_gain = 1.0;
        this.v_cf = this.center_frequency.get_dvalue();
        this.v_sr = this.sample_rate.get_dvalue();
        if (this.v_sr != 0.0 && this.v_sr != this.v_sr_old) {
            this.graph_start_frequency.set_value(0.0);
            this.graph_end_frequency.set_value(this.v_sr / 2.0);
            this.v_sr_old = this.v_sr;
        }
        if (this.v_cf > this.v_sr / 2.0) {
            this.v_cf = this.v_sr / 2.0;
            this.center_frequency.set_value(this.v_cf);
        }
        this.filter.configure(this.type, this.v_cf, this.v_sr, this.v_q, this.v_filter_gain);
        this.constants = this.filter.constants();
        this.v_dbmode = this.db_mode.get_value();
        this.v_start = this.graph_start_frequency.get_dvalue();
        this.v_end = this.graph_end_frequency.get_dvalue();
        this.repaint();
    }

    private boolean need_new_filter() {
        boolean need = false;
        need |= this.type != this.filter_hash.get(this.filter_type.get_value());
        need |= this.v_q != this.q.get_pct_dvalue();
        need |= this.v_filter_gain != this.filter_gain.get_dvalue();
        need |= this.v_cf != this.center_frequency.get_dvalue();
        need |= this.v_sr != this.sample_rate.get_dvalue();
        need |= this.v_dbmode != this.db_mode.get_value();
        need |= this.v_start != this.graph_start_frequency.get_dvalue();
        return need |= this.v_end != this.graph_end_frequency.get_dvalue();
    }

    private void setup_controls() {
        int max = 100000000;
        this.q = new TextFieldController(this.q_textfield, "0.707", max, 0.0);
        this.filter_gain = new TextFieldController(this.gain_textfield, "1", max, -max);
        this.center_frequency = new TextFieldController(this.cf_textfield, "1000", max, 0.0);
        this.graph_start_frequency = new TextFieldController(this.startf_textfield, "500", max, 0.0);
        this.graph_end_frequency = new TextFieldController(this.endf_textfield, "1500", max, 0.0);
        this.sample_rate = new TextFieldController(this.rate_textfield, "40000", max, 0.0);
        this.filter_type = new ComboBoxTextController(this.filter_type_combobox, this.filter_names, "Bandpass", this.filter_tips, "Select filter type");
        this.db_mode = new ToggleButtonController(this.db_radiobutton, false);
        this.selected_tab = new TabPanelController(this.tabbed_pane, 0);
        this.v_dbmode = this.db_mode.get_value();
        this.db_radiobutton.setText("<html>20 log<sub>10</sub></html>");
    }

    private void set_defaults() {
        if (BiQuadDesignerPanel.ask_user(this, "Okay to reset to defaults?", "Set Program Defaults")) {
            this.q.set_value("0.707");
            this.filter_gain.set_value("1");
            this.center_frequency.set_value("10000");
            this.graph_start_frequency.set_value("0");
            this.graph_end_frequency.set_value("20000");
            this.sample_rate.set_value("40000");
            this.filter_type.set_value("Bandpass");
            this.db_mode.set_value(false);
            this.selected_tab.set_value("0");
        }
    }

    private void launch_help() {
        try {
            Desktop.getDesktop().browse(URI.create("http://arachnoid.com/BiQuadDesigner"));
        }
        catch (Exception e) {
            this.p(e);
        }
    }

    public static boolean ask_user(JComponent src, String query, String title, Object[] options) {
        if (options != null) {
            return JOptionPane.showOptionDialog(src, query, title, 0, 3, null, options, options[0]) == 0;
        }
        return JOptionPane.showConfirmDialog(src, query, title, 0) == 0;
    }

    public static boolean ask_user(JComponent src, String query, String title) {
        return BiQuadDesignerPanel.ask_user(src, query, title, null);
    }

    public static void tell_user(JFrame src, String message, String title) {
        JOptionPane.showMessageDialog(src, message, title, 1);
    }

    public <T> void p(T s) {
        System.out.println(s);
    }

    protected void copy_to_clipboard() {
        String s = this.description_text.getText();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection transferable = new StringSelection(s);
        clipboard.setContents(transferable, null);
    }

    private void close() {
        if (this.parent instanceof BiQuadDesigner) {
            ((BiQuadDesigner)this.parent).close();
        }
    }

    private void initComponents() {
        this.jLabel8 = new JLabel();
        this.buttonGroup1 = new ButtonGroup();
        this.tabbed_pane = new JTabbedPane();
        this.graph_panel_tab = new JPanel();
        this.graph_control_panel = new JPanel();
        this.mouse_pos_label = new JLabel();
        this.description_container = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.description_text = new JTextArea();
        this.control_panel = new JPanel();
        this.panela = new JPanel();
        this.jLabel1 = new JLabel();
        this.filter_type_combobox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.q_textfield = new JTextField();
        this.jLabel6 = new JLabel();
        this.gain_textfield = new JTextField();
        this.jLabel3 = new JLabel();
        this.cf_textfield = new JTextField();
        this.jLabel7 = new JLabel();
        this.rate_textfield = new JTextField();
        this.defaults_button = new JButton();
        this.panelb = new JPanel();
        this.jLabel4 = new JLabel();
        this.startf_textfield = new JTextField();
        this.jLabel5 = new JLabel();
        this.endf_textfield = new JTextField();
        this.jLabel9 = new JLabel();
        this.linear_radiobutton = new JRadioButton();
        this.db_radiobutton = new JRadioButton();
        this.copy_button = new JButton();
        this.help_button = new JButton();
        this.quit_button = new JButton();
        this.jLabel8.setText("jLabel7");
        this.setLayout(new BorderLayout());
        this.tabbed_pane.setTabPlacement(3);
        this.graph_panel_tab.setLayout(new BorderLayout());
        this.graph_control_panel.setLayout(new GridBagLayout());
        this.mouse_pos_label.setFont(new Font("Monospaced", 0, 12));
        this.mouse_pos_label.setText("                 ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.graph_control_panel.add((Component)this.mouse_pos_label, gridBagConstraints);
        this.graph_panel_tab.add((Component)this.graph_control_panel, "South");
        this.tabbed_pane.addTab("Filter Graph", this.graph_panel_tab);
        this.description_container.setLayout(new BorderLayout());
        this.description_text.setColumns(20);
        this.description_text.setFont(new Font("Monospaced", 0, 12));
        this.description_text.setRows(5);
        this.description_text.setMargin(new Insets(4, 4, 4, 4));
        this.jScrollPane1.setViewportView(this.description_text);
        this.description_container.add((Component)this.jScrollPane1, "Center");
        this.tabbed_pane.addTab("Filter Description", this.description_container);
        this.add((Component)this.tabbed_pane, "Center");
        this.control_panel.setLayout(new GridBagLayout());
        this.panela.setLayout(new GridBagLayout());
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Type:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panela.add((Component)this.jLabel1, gridBagConstraints);
        this.filter_type_combobox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.filter_type_combobox.setToolTipText("Select a filter type");
        this.panela.add((Component)this.filter_type_combobox, new GridBagConstraints());
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Q:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panela.add((Component)this.jLabel2, gridBagConstraints);
        this.q_textfield.setHorizontalAlignment(4);
        this.q_textfield.setText("0.00");
        this.q_textfield.setToolTipText("Actual Q value is 1/100 displayed value<br/>\nNo effect on highshelf, lowshelf");
        this.q_textfield.setMaximumSize(new Dimension(60, Integer.MAX_VALUE));
        this.q_textfield.setMinimumSize(new Dimension(60, 19));
        this.q_textfield.setPreferredSize(new Dimension(60, 19));
        this.panela.add((Component)this.q_textfield, new GridBagConstraints());
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText("Filter Gain DB:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panela.add((Component)this.jLabel6, gridBagConstraints);
        this.gain_textfield.setHorizontalAlignment(4);
        this.gain_textfield.setText("0.00");
        this.gain_textfield.setToolTipText("Only affects peak, highshelf and lowshelf filters");
        this.gain_textfield.setMaximumSize(new Dimension(60, Integer.MAX_VALUE));
        this.gain_textfield.setMinimumSize(new Dimension(60, 19));
        this.gain_textfield.setPreferredSize(new Dimension(60, 19));
        this.panela.add((Component)this.gain_textfield, new GridBagConstraints());
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Center Freq.:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panela.add((Component)this.jLabel3, gridBagConstraints);
        this.cf_textfield.setHorizontalAlignment(4);
        this.cf_textfield.setText("0.00");
        this.cf_textfield.setToolTipText("Filter center frequency Hz");
        this.cf_textfield.setMaximumSize(new Dimension(80, Integer.MAX_VALUE));
        this.cf_textfield.setMinimumSize(new Dimension(60, 19));
        this.cf_textfield.setPreferredSize(new Dimension(80, 19));
        this.panela.add((Component)this.cf_textfield, new GridBagConstraints());
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText("Rate:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panela.add((Component)this.jLabel7, gridBagConstraints);
        this.rate_textfield.setHorizontalAlignment(4);
        this.rate_textfield.setText("0.00");
        this.rate_textfield.setToolTipText("Sample Rate samples/second");
        this.rate_textfield.setMaximumSize(new Dimension(80, Integer.MAX_VALUE));
        this.rate_textfield.setMinimumSize(new Dimension(60, 19));
        this.rate_textfield.setPreferredSize(new Dimension(80, 19));
        this.panela.add((Component)this.rate_textfield, new GridBagConstraints());
        this.defaults_button.setText("Defaults");
        this.defaults_button.setToolTipText("Set all default values");
        this.defaults_button.setMargin(new Insets(2, 4, 2, 4));
        this.defaults_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BiQuadDesignerPanel.this.defaults_buttonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panela.add((Component)this.defaults_button, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.control_panel.add((Component)this.panela, gridBagConstraints);
        this.panelb.setLayout(new GridBagLayout());
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Start:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panelb.add((Component)this.jLabel4, gridBagConstraints);
        this.startf_textfield.setHorizontalAlignment(4);
        this.startf_textfield.setText("0.00");
        this.startf_textfield.setToolTipText("Graph start frequency Hz");
        this.startf_textfield.setMaximumSize(new Dimension(60, Integer.MAX_VALUE));
        this.startf_textfield.setMinimumSize(new Dimension(60, 19));
        this.startf_textfield.setPreferredSize(new Dimension(80, 19));
        this.panelb.add((Component)this.startf_textfield, new GridBagConstraints());
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("End:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panelb.add((Component)this.jLabel5, gridBagConstraints);
        this.endf_textfield.setHorizontalAlignment(4);
        this.endf_textfield.setText("0.00");
        this.endf_textfield.setToolTipText("Graph end frequency Hz");
        this.endf_textfield.setMaximumSize(new Dimension(60, Integer.MAX_VALUE));
        this.endf_textfield.setMinimumSize(new Dimension(60, 19));
        this.endf_textfield.setPreferredSize(new Dimension(80, 19));
        this.panelb.add((Component)this.endf_textfield, new GridBagConstraints());
        this.jLabel9.setHorizontalAlignment(4);
        this.jLabel9.setText("Vert. Units:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panelb.add((Component)this.jLabel9, gridBagConstraints);
        this.buttonGroup1.add(this.linear_radiobutton);
        this.linear_radiobutton.setSelected(true);
        this.linear_radiobutton.setText("Linear");
        this.linear_radiobutton.setToolTipText("Choose linear vertical axis scaling");
        this.panelb.add((Component)this.linear_radiobutton, new GridBagConstraints());
        this.buttonGroup1.add(this.db_radiobutton);
        this.db_radiobutton.setText("20 Log10");
        this.db_radiobutton.setToolTipText("Choose decibel vertical axis scaling");
        this.db_radiobutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BiQuadDesignerPanel.this.db_radiobuttonActionPerformed(evt);
            }
        });
        this.panelb.add((Component)this.db_radiobutton, new GridBagConstraints());
        this.copy_button.setText("Copy");
        this.copy_button.setToolTipText("Copy filter description to system clipboard");
        this.copy_button.setMargin(new Insets(2, 4, 2, 4));
        this.copy_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BiQuadDesignerPanel.this.copy_buttonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panelb.add((Component)this.copy_button, gridBagConstraints);
        this.help_button.setText("Help");
        this.help_button.setToolTipText("Visit the BiQuadDesigner Home Page");
        this.help_button.setMargin(new Insets(2, 4, 2, 4));
        this.help_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BiQuadDesignerPanel.this.help_buttonMouseClicked(evt);
            }
        });
        this.panelb.add((Component)this.help_button, new GridBagConstraints());
        this.quit_button.setText("Quit");
        this.quit_button.setToolTipText("Exit BiQuadDesigner");
        this.quit_button.setMargin(new Insets(2, 4, 2, 4));
        this.quit_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BiQuadDesignerPanel.this.quit_buttonMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.panelb.add((Component)this.quit_button, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.control_panel.add((Component)this.panelb, gridBagConstraints);
        this.add((Component)this.control_panel, "South");
    }

    private void quit_buttonMouseClicked(MouseEvent evt) {
        this.close();
    }

    private void defaults_buttonMouseClicked(MouseEvent evt) {
        this.set_defaults();
    }

    private void help_buttonMouseClicked(MouseEvent evt) {
        this.launch_help();
    }

    private void copy_buttonMouseClicked(MouseEvent evt) {
        this.copy_to_clipboard();
    }

    private void db_radiobuttonActionPerformed(ActionEvent evt) {
    }

    class PeriodicEvents
    extends TimerTask {
        PeriodicEvents() {
        }

        @Override
        public void run() {
            BiQuadDesignerPanel.this.update_controls();
            BiQuadDesignerPanel.this.update_description();
        }
    }
}

