/*
 * Decompiled with CFR 0.152.
 */
package biquaddesigner;

import biquaddesigner.BiQuadDesignerPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public final class GraphPanel
extends JPanel {
    BiQuadDesignerPanel parent;
    int gsize = 2000;
    double xstart;
    double xend;
    double ystart;
    double yend;
    boolean db_mode;
    double gain_offset;
    double width_factor = 1.0;
    int width = -1;
    int height = -1;
    int[] offsets;
    int font_factor;
    boolean show_scale_numbers = true;
    int graphicw = 200;
    int graphich = 150;
    double maxval;
    double minval;
    ArrayList<Double> ydata;

    public GraphPanel(BiQuadDesignerPanel p) {
        this.parent = p;
        this.initComponents();
    }

    private double ntrp(double x, double xa, double xb, double ya, double yb) {
        return (x - xa) * (yb - ya) / (xb - xa) + ya;
    }

    private double get_filter_result(double x) {
        return this.db_mode ? this.parent.filter.log_result(x) : this.parent.filter.result(x);
    }

    private void handle_mouse_click(MouseEvent evt) {
        if (this.parent.debug && evt.getButton() == 3) {
            try {
                BufferedImage bi = new BufferedImage(this.graphicw, this.graphich, 2);
                Graphics2D g = bi.createGraphics();
                this.draw_graph(this.graphicw, this.graphich, g);
                int image_num = 0;
                File f = null;
                do {
                    f = new File("BiQuadDesigner_image_" + image_num + ".png");
                    ++image_num;
                } while (f.exists());
                ImageIO.write((RenderedImage)bi, "PNG", f);
                ++image_num;
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        this.draw_graph(this.getWidth(), this.getHeight(), g);
    }

    private void draw_graph(int width, int height, Graphics gg) {
        this.width = width;
        this.height = height;
        this.width_factor = (double)width / 800.0;
        this.show_scale_numbers = this.width_factor > 0.85;
        this.offsets = this.show_scale_numbers ? new int[]{(int)(70.0 * this.width_factor), (int)(10.0 * this.width_factor), (int)(-36.0 * this.width_factor), (int)(-25.0 * this.width_factor)} : new int[]{(int)(10.0 * this.width_factor), (int)(10.0 * this.width_factor), (int)(-10.0 * this.width_factor), (int)(-10.0 * this.width_factor)};
        this.font_factor = (int)(5.0 * this.width_factor);
        Graphics2D g = (Graphics2D)gg;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.xstart = this.parent.graph_start_frequency.get_dvalue();
        this.xend = this.parent.graph_end_frequency.get_dvalue();
        this.ystart = 0.0;
        this.yend = 1.0;
        this.db_mode = this.parent.db_mode.get_value();
        if (this.db_mode) {
            this.ystart = -100.0;
            this.yend = 0.0;
        }
        if (this.parent.filter != null) {
            this.ydata = new ArrayList();
            this.maxval = -1.0E30;
            this.minval = 1.0E30;
            for (int i = 0; i < this.gsize; ++i) {
                double x = this.ntrp(i, 0.0, this.gsize, this.xstart, this.xend);
                this.acquire_value(x, this.ydata, true);
            }
            this.acquire_value(this.parent.v_cf, this.ydata, false);
            this.ystart = this.minval;
            this.yend = this.maxval;
        }
        double gain_offset = this.db_mode ? 0.0 : 1.0;
        this.ystart = (this.ystart - gain_offset) / this.parent.y_axis_gain + gain_offset;
        this.yend = (this.yend - gain_offset) / this.parent.y_axis_gain + gain_offset;
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
        this.draw_grid(this.offsets[0], width + this.offsets[2], height + this.offsets[3], this.offsets[1], g);
        if (this.parent.filter != null) {
            this.draw_trace(this.offsets[0], width + this.offsets[2], height + this.offsets[3], this.offsets[1], g);
        }
    }

    private void acquire_value(double x, ArrayList<Double> ydata, boolean collect) {
        double y = this.get_filter_result(x);
        if (collect) {
            ydata.add(y);
        }
        this.maxval = Math.max(y, this.maxval);
        this.minval = Math.min(this.minval, y);
    }

    private void draw_trace(int xa, int xb, int ya, int yb, Graphics2D g) {
        boolean ox = false;
        boolean oy = false;
        g.setColor(new Color(0.0f, 0.25f, 1.0f));
        GeneralPath gp = new GeneralPath();
        boolean first = true;
        for (int i = 0; i < this.gsize; ++i) {
            double y = this.ydata.get(i);
            int px = (int)this.ntrp(i, 0.0, this.gsize, xa, xb);
            int py = (int)this.ntrp(y, this.ystart, this.yend, ya, yb);
            if (first) {
                gp.moveTo(px, py);
                first = false;
                continue;
            }
            gp.lineTo(px, py);
        }
        g.draw(gp);
    }

    private void draw_grid(int xa, int xb, int ya, int yb, Graphics2D g) {
        int pv;
        int hs = 10;
        int vs = 5;
        double v = 0.0;
        g.setColor(new Color(0.7f, 0.7f, 0.7f));
        for (int y = 0; y <= vs; ++y) {
            pv = (int)this.ntrp(y, 0.0, vs, ya, yb);
            g.drawLine(xa, pv, xb, pv);
        }
        for (int x = 0; x <= hs; ++x) {
            pv = (int)this.ntrp(x, 0.0, hs, xa, xb);
            g.drawLine(pv, ya, pv, yb);
        }
        if (this.show_scale_numbers) {
            String st;
            int pv2;
            g.setColor(Color.black);
            Font f = new Font("Monospaced", 0, (int)(this.width_factor * 12.0));
            g.setFont(f);
            int h_off = this.font_factor * 7;
            int v_off = this.font_factor * 4;
            for (int y = 0; y <= vs; ++y) {
                pv2 = (int)this.ntrp(y, 0.0, vs, ya, yb);
                v = this.ntrp(y, 0.0, vs, this.ystart, this.yend);
                st = String.format("%+.1f", v);
                int len = st.length();
                g.drawString(st, 64 - len * 8, pv2 + this.font_factor);
            }
            for (int x = 0; x <= hs; ++x) {
                pv2 = (int)this.ntrp(x, 0.0, hs, xa, xb);
                v = this.ntrp(x, 0.0, hs, this.xstart, this.xend);
                st = String.format("%+.1f", v);
                g.drawString(st, pv2 - h_off, ya + v_off);
            }
        }
    }

    private void mouse_move(MouseEvent evt) {
        double liny;
        double logy;
        double x = this.ntrp(evt.getX(), this.offsets[0], this.width + this.offsets[2], this.xstart, this.xend);
        double y = this.ntrp(evt.getY(), this.offsets[1], this.height + this.offsets[3], this.yend, this.ystart);
        if (this.db_mode) {
            logy = y;
            liny = Math.pow(10.0, y / 20.0);
        } else {
            logy = Math.log10(y) * 20.0;
            liny = y;
        }
        String s = String.format("Mouse cursor: x = %8.4g Hz, y = %8.4g Units / %8.4g db", x, liny, logy);
        this.parent.mouse_pos_label.setText(s);
    }

    private void mouse_exit() {
        this.parent.mouse_pos_label.setText("     ");
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(600, 400));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GraphPanel.this.formMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                GraphPanel.this.formMouseExited(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                GraphPanel.this.formMouseMoved(evt);
            }
        });
        this.setLayout(new GridBagLayout());
    }

    private void formMouseMoved(MouseEvent evt) {
        this.mouse_move(evt);
    }

    private void formMouseExited(MouseEvent evt) {
        this.mouse_exit();
    }

    private void formMouseClicked(MouseEvent evt) {
        this.handle_mouse_click(evt);
    }
}

