#!/usr/bin/env python
# -*- coding: utf-8 -*-

import cadquery as cq
import math

def cup(radius,height,offset=0):
    return (
        cq.Workplane("XY")
        .circle(radius)
        .extrude(height)
        .translate((0,0,offset))
    )

def handle(radius,cr,x,y):
    return (
        cq.Workplane("XY")
        .moveTo(radius,0)
        .circle(cr)
        .revolve()
        .translate((-x,0,y/2))
    )

def smooth(shape,f):
    return (
        shape.edges().fillet(f)
    )

def save(shape,name):
    cq.exporters.export(shape,name)

# all dimensions in mm

# thickness of cup wall
wall = 3 

# cup height
height = 100

# enter desired volume here : ml
desired_volume = 600

# calculate internal radius ir
# ir = sqrt(v / (height * pi))
# for desired volume

iradius = math.sqrt(desired_volume * 1000/((height-wall)*math.pi))

# acquire external radius
radius = iradius+wall

# volume units: milliliters
volume = (radius-wall)**2 * math.pi * (height-wall) * .001
print(f'Cup volume = {volume:.2f} ml')

outside = cup(radius,height)
inside = cup(radius-wall,height,wall)
handle = handle(radius*0.6,5,radius,height)

for n in range(6):
  cup = None
  match n:
    case 0:
      cup = outside
    case 1:
      cup = inside
    case 2:
      cup = outside+inside
    case 3:
      cup = outside-inside
    case 4:
      cup = outside+handle-inside
    case 5:
      cupa = outside+handle-inside
      cup = smooth(cupa,wall/2-0.01)
      
  save(cup,f'frames/cup{n:03d}.stl')
  


