#!/usr/bin/env python

import cadquery as cq
import os,math

def cylinder(radius,height,offset=0):
    return cq.Workplane("XY").circle(radius).extrude(height).translate((0,0,offset))

def torus(radius,cr,x,y):
    return cq.Workplane("XY").moveTo(radius,0).circle(cr).revolve().translate((-x,0,y/2))

def smooth(shape,f):
    return shape.edges().fillet(f)

def save(shape,name):
    cq.exporters.export(shape,name)

# dimensions in mm
height = 100
wall = 3
desired_volume = 600 # units ml
radius = math.sqrt(desired_volume * 1000/((height-wall)*math.pi)) + wall

print(f'Cup dimensions | wall thickness: {wall:.2f} mm radius: {radius:.2f} mm height: {height:.2f} mm volume: {desired_volume:.2f} ml')

outside = cylinder(radius,height)
inside = cylinder(radius-wall,height,wall)
handle = torus(radius*0.6,5,radius,height)
cup1 = (outside+handle-inside)
cup2 = smooth(cup1,wall/2-0.01)

if 'JPY_PARENT_PID' in os.environ:
    cup2
else:
    save(cup2,'cup_simple.stl')
