#!/usr/bin/env python

import cadquery as cq
import os

def save(shape,name):
    cq.exporters.export(shape,name)
    
def update_pos(orig,delta):
    res = []
    for n in range(len(orig)):
        res  += [orig[n]+delta[n]]
    return res

id = 30
od = 40
pl = 200
rotrad = 50

orig = (0,0,0)
pipe = (
    cq.Workplane("XZ", origin=orig)
    .circle(od)
    .circle(id)
    .extrude(pl)
)
orig = update_pos(orig,(0,-pl,0))
pipe += (
    cq.Workplane("XZ",origin=orig)    
    .circle(od)
    .circle(id)
    .revolve(90,(rotrad,-1,0),(rotrad,0,0))
    
)
orig = update_pos(orig,(rotrad,-rotrad,0))
pipe += (
    cq.Workplane("YZ",origin=orig)
    .circle(od)
    .circle(id)
    .extrude(pl/2)
)
orig = update_pos(orig,(pl/2,0,0))
pipe += (
    cq.Workplane("YZ",origin=orig)    
    .circle(od)
    .circle(id)
    .revolve(90,(-rotrad,0,0),(-rotrad,-1,0))
)
orig = update_pos(orig,(rotrad,-rotrad,0))
pipe += (
    cq.Workplane("XZ",origin=orig)
    .circle(od)
    .circle(id)
    .extrude(pl)
)

if 'JPY_PARENT_PID' in os.environ:
    pipe
else:
    save(pipe,f"cadquery_pipe_{id}_{od}_{rotrad}.stl")
