#!/usr/bin/env python

import cadquery as cq
import os
from operator import add

def save(shape,name):
    cq.exporters.export(shape,name)
    
id = 25
od = 32
rr = 75
pl = 200

orig = [0,0,0]

def update(orig,delta):
    return list(map(add, orig, delta))

def extrude(plane,orig,od,id,ex):
    return cq.Workplane(plane,origin=orig).circle(od).circle(id).extrude(ex)

def revolve(plane,orig,od,id,a,r,p):
    return cq.Workplane(plane,origin=orig).circle(od).circle(id).revolve(a,(r,0,0),(r,p,0))

pipe = extrude("XZ",orig,od,id,pl)
orig = update(orig,(0,-pl,0))
pipe += revolve("XZ",orig,od,id,90,rr,1)
orig = update(orig,(rr,-rr,0))
pipe += extrude("YZ",orig,od,id,pl/2)
orig = update(orig,(pl/2,0,0))
pipe += revolve("YZ",orig,od,id,90,-rr,-1)
orig = update(orig,(rr,-rr,0))
pipe += extrude("XZ",orig,od,id,pl)

pipe
if 'JPY_PARENT_PID' in os.environ:
    pipe
else:
    save(pipe,'simplest_pipe.stl')
