/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class DataProspector
extends JFrame {
    public String userPath;
    public String configPath;
    public String fileSep;
    public String lineSep;
    public ConfigurationHandler configHandler;
    public DataPane dataPane;
    public boolean readOnly = true;
    public String driverTag = null;
    private HelpPanel helpPanel;
    public LogPanel logPanel;
    final double programVersion = 3.1;
    final String programName = "DataProspector";
    final String programTitle = "DataProspector 3.1";
    String[] configDefaults = new String[]{"Driver=com.mysql.jdbc.Driver\torg.postgresql.Driver", "ShowDatabases_mysql=show databases;", "ShowDatabases_postgresql=select datname from pg_database;", "ShowTables_mysql=show tables;", "ShowTables_postgresql=select tablename from pg_tables where tablename not like 'pg_%';", "ColumnDelim_mysql=`", "ColumnDelim_postgresql=", "Host=jdbc:mysql://your-host-here\tjdbc:postgresql://your-host-here", "User=user name here", "ReadOnly=1", "LogLongForm=0"};
    private JPanel bottomPanel;
    private JPanel configurationPanel;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTextArea messageArea;
    private JTabbedPane selectorPane;

    public DataProspector() {
        this.userPath = System.getProperty("user.home");
        this.fileSep = System.getProperty("file.separator");
        this.lineSep = System.getProperty("line.separator");
        this.userPath = this.userPath + this.fileSep + "." + "DataProspector";
        this.configPath = this.userPath + this.fileSep + "DataProspector" + ".ini";
        this.setTitle("DataProspector 3.1");
        this.setIconImage(new ImageIcon(this.getClass().getResource("DataProspector.png")).getImage());
        File f = new File(this.userPath);
        f.mkdirs();
        this.initComponents();
        this.configHandler = new ConfigurationHandler(this.configPath, this);
        this.configHandler.readConfig(this.configDefaults);
        this.dataPane = new DataPane(this);
        this.selectorPane.addTab("Data", null, this.dataPane, "Data viewing and editing");
        this.helpPanel = new HelpPanel(this);
        this.selectorPane.addTab("Help", null, this.helpPanel, "Help and useful hints");
        this.logPanel = new LogPanel(this);
        this.selectorPane.addTab("Event Log", null, this.logPanel, "A record of events and errors");
        this.getConfigurationPanel().setupComboBoxes(false);
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        this.pack();
        this.setSize(ss.width * 2 / 3, ss.height * 2 / 3);
        this.setLocation(ss.width / 6, ss.height / 6);
        this.show();
        this.resetFont(this.messageArea);
        this.resetFont(this.helpPanel.helpTextArea);
        this.resetFont(this.logPanel.logTextArea);
        this.getConfigurationPanel().checkReadOnly();
        this.getConfigurationPanel().fetchDatabases(true);
    }

    public void resetFont(Component c) {
        c.setFont(new Font("Monospaced", 0, c.getFont().getSize()));
    }

    public DataPane getDataPane() {
        return this.dataPane;
    }

    public ConfigurationPanel getConfigurationPanel() {
        return (ConfigurationPanel)this.configurationPanel;
    }

    public void putMessage(String title, Exception e) {
        if (this.messageArea != null) {
            this.messageArea.setText(title + " error : " + e.getMessage());
        }
        this.logPanel.doMessage(title, e);
    }

    public void clearMessage() {
        this.messageArea.setText("");
    }

    public void addComboItem(JComboBox box, String s) {
        if (s != null && (s = s.trim()).length() > 0) {
            ActionListener[] al = this.removeActionListeners(box);
            for (int i = 0; i < box.getItemCount(); ++i) {
                if (!box.getItemAt(i).equals(s)) continue;
                box.removeItemAt(i);
            }
            box.insertItemAt(s, 0);
            box.setSelectedItem(s);
            this.restoreActionListeners(box, al);
        }
    }

    public void addComboItem(JComboBox box) {
        this.addComboItem(box, (String)box.getSelectedItem());
    }

    public void setSelectedItem(JComboBox box, String s) {
        ActionListener[] al = this.removeActionListeners(box);
        box.setSelectedItem(s);
        if (box.getSelectedIndex() < 0 && box.getItemCount() > 0) {
            box.setSelectedIndex(0);
        }
        this.restoreActionListeners(box, al);
    }

    public void setSelectedIndex(JComboBox box, int i) {
        ActionListener[] al = this.removeActionListeners(box);
        if (box.getItemCount() > i) {
            box.setSelectedIndex(i);
        }
        this.restoreActionListeners(box, al);
    }

    public ActionListener[] removeActionListeners(JComboBox box) {
        ActionListener[] al = box.getActionListeners();
        for (int i = 0; i < al.length; ++i) {
            box.removeActionListener(al[i]);
        }
        return al;
    }

    public void restoreActionListeners(JComboBox box, ActionListener[] al) {
        for (int i = 0; i < al.length; ++i) {
            box.addActionListener(al[i]);
        }
    }

    private void initComponents() {
        this.selectorPane = new JTabbedPane();
        this.configurationPanel = new ConfigurationPanel(this);
        this.bottomPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.messageArea = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DataProspector.this.exitForm(evt);
            }
        });
        this.selectorPane.setTabPlacement(3);
        this.selectorPane.addTab("Selections", null, this.configurationPanel, "Setup and database selection");
        this.getContentPane().add((Component)this.selectorPane, "Center");
        this.bottomPanel.setLayout(new GridBagLayout());
        this.jLabel1.setText("Messages:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottomPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.messageArea.setEditable(false);
        this.messageArea.setLineWrap(true);
        this.messageArea.setRows(3);
        this.messageArea.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.messageArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottomPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.pack();
    }

    public void performExit() {
        this.getConfigurationPanel().setupComboBoxes(true);
        this.configHandler.writeConfig();
        System.exit(0);
    }

    private void exitForm(WindowEvent evt) {
        this.performExit();
    }

    public static void main(String[] args) {
        new DataProspector().show();
    }
}

