/*
 * Decompiled with CFR 0.152.
 */
package netscape.security;

public final class Privilege {
    public static final int N_PERMISSIONS = 15;
    public static final int FORBIDDEN = 0;
    public static final int ALLOWED = 1;
    public static final int BLANK = 2;
    public static final int N_DURATIONS = 240;
    public static final int SCOPE = 16;
    public static final int SESSION = 32;
    public static final int FOREVER = 64;
    private int permission = 0;
    private int duration = 16;

    Privilege(int n2, int n3) {
        this.permission = n2;
        this.duration = n3;
    }

    public static Privilege findPrivilege(int n2, int n3) {
        return new Privilege(n2, n3);
    }

    public static int add(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return 0;
        }
        if (n2 == 2) {
            return n3;
        }
        if (n3 == 2) {
            return n2;
        }
        if (n2 == 1 || n3 == 1) {
            return 1;
        }
        return 2;
    }

    public static Privilege add(Privilege privilege, Privilege privilege2) {
        int n2 = Privilege.add(privilege.getPermission(), privilege2.getPermission());
        return new Privilege(n2, privilege.getDuration());
    }

    public boolean samePermission(Privilege privilege) {
        return this.samePermission(privilege.getPermission());
    }

    public boolean samePermission(int n2) {
        return this.permission == n2;
    }

    public boolean sameDuration(Privilege privilege) {
        return this.sameDuration(privilege.getDuration());
    }

    public boolean sameDuration(int n2) {
        return this.duration == n2;
    }

    public boolean isAllowed() {
        return this.permission == 1;
    }

    public boolean isForbidden() {
        return this.permission == 0;
    }

    public boolean isBlank() {
        return this.permission == 2;
    }

    public int getPermission() {
        return this.permission;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean equals(Object object) {
        if (object instanceof Privilege) {
            Privilege privilege = (Privilege)object;
            return this.permission == privilege.getPermission() && this.duration == privilege.getDuration();
        }
        return false;
    }
}

