/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * FFTExplorerApplet.java
 *
 * Created on Mar 27, 2009, 1:03:09 AM
 */
package fftexplorer;

import javax.swing.UIManager.*;

import javax.swing.*;
import javax.swing.UIManager.*;
import java.util.Date.*;

import netscape.javascript.*;
import java.awt.*;
import java.text.Format.*;
import java.text.DateFormat.*;

/**
 *
 * @author lutusp
 */
public class FFTExplorerApplet extends javax.swing.JApplet {

    FFTExplorer mainPanel;
    String oldCookie = null;

    /** Initializes the applet FFTExplorerApplet */
    @Override
    public void init() {
        try {

            Thread t = new Thread() {

                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(2000);
                        } catch (Exception e) {
                        }
                        writeCookie();
                    }
                }
            };
            t.start();

            java.awt.EventQueue.invokeAndWait(new Runnable() {

                public void run() {
                    try {
                        // Set to use system-specific L&F
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    } catch (Exception e) {
                        // handle exception
                    }
                    initComponents();
                    mainPanel = new FFTExplorer(this, true, null);

                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    getContentPane().add(mainPanel, gridBagConstraints);
                    SwingUtilities.invokeLater(
                            new Runnable() {

                                public void run() {
                                    String config = readCookie();
                                    mainPanel.setConfig(config);
                                }
                            });

                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void alert(String data) {
        System.out.println("alert: " + data);
    }

    void writeCookie(String data) {
        if (data != null) {
            data = StringEscapeUnescape.stringToHex(data);
            try {
                if (data != null) {
                    java.util.Calendar c = java.util.Calendar.getInstance();
                    c.add(java.util.Calendar.MONTH, 1);
                    String expires = "; expires=" + c.getTime().toString();
                    JSObject browser = JSObject.getWindow(this);
                    if (browser != null) {
                        JSObject document = (JSObject) browser.getMember("document");
                        if (document != null) {
                            String cookie = data + expires;
                            document.setMember("cookie", cookie);
                        }
                    }
                }
            } catch (Exception e) {
                System.out.println("writeCookie failed: " + e);
            }
        }
    }

    public void writeCookie() {
        if (mainPanel != null) {
            // only write a cookie if the entries have changed
            String data = mainPanel.getConfig();

            if (data != null && oldCookie != null && !data.equals(oldCookie)) {
                //System.out.println("accepted data :" + data);
                writeCookie(data);
            }
            oldCookie = data;
        }
    }

    public String readCookie() {
        String result = null;
        try {
            JSObject browser = (JSObject) JSObject.getWindow(this);
            JSObject document = (JSObject) browser.getMember("document");
            //alert("readCookie myDocument = " + document);
            if (document != null) {
                String myCookie = (String) document.getMember("cookie");
                if (myCookie != null && myCookie.length() > 0) {
                    result = myCookie;
                    result = result.replaceFirst("(.*?);.*", "$1");
                }
            }
        } catch (Exception e) {
            System.out.println("readCookie exception: " + e);
        }
        if (result != null) {
            result = StringEscapeUnescape.hexToString(result);
        }
        return result;
    }

    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setLayout(new java.awt.GridBagLayout());
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
