/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
package fftexplorer;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
/**
 *
 * @author lutusp
 */
final public class UserActionManager {

    //int min, max;
    JTextField field = null;
    JComboBox box = null;
    FFTExplorer parent;
    double sens = 1;
    double dmin, dmax;
    int imin, imax;
    String tip1 = "Spin mouse wheel to change";
    String tip2 = " (spin mouse wheel to change)";

    public UserActionManager(double sens, double min, double max, JTextField field, FFTExplorer p) {
        this.field = field;
        dmin = min;
        dmax = max;
        init(sens, p,field);
        assignHandlers(field);
    }

    public UserActionManager(JComboBox box, FFTExplorer p) {
        this.box = box;
        init(1, p,box);
        assignHandlers(box);
    }

    void init(double sens, FFTExplorer p,JComponent comp) {
        parent = p;
        this.sens = sens;
        setTip(comp);
    }

    void setTip(JComponent comp) {
        String tip = comp.getToolTipText();
        tip = (tip == null || tip.length() == 0)?tip1:tip + tip2;
        comp.setToolTipText(tip);
    }

    public void assignHandlers(Component comp) {
        comp.addMouseWheelListener(new java.awt.event.MouseWheelListener() {

            public void mouseWheelMoved(java.awt.event.MouseWheelEvent evt) {
                handleMouseWheelMoved(evt);
            }
        });
        comp.addKeyListener(new java.awt.event.KeyAdapter() {

            @Override
            public void keyReleased(java.awt.event.KeyEvent evt) {
                handleKeyReleased(evt);
            }
        });
    }

    private void handleKeyReleased(KeyEvent evt) {
        int n = 0;
        double sign = 0;
        double v = sens;
        v = (evt.isShiftDown()) ? v * 10 : v;
        v = (evt.isAltDown()) ? v * 100 : v;
        int kcode = evt.getKeyCode();
        //String code = KeyEvent.getKey_Text(kcode);
        //System.out.println("key: " + code);
        if (kcode == KeyEvent.VK_ENTER) {
            sign = 1;
        } else if (kcode == KeyEvent.VK_HOME) {
            n = 100;
            sign = 1;
        } else if (kcode == KeyEvent.VK_END) {
            n = -100;
            sign = 1;
        } else if (kcode == KeyEvent.VK_PAGE_UP) {
            n = 10;
            sign = 1;
        } else if (kcode == KeyEvent.VK_PAGE_DOWN) {
            n = -10;
            sign = 1;
        } else if (kcode == KeyEvent.VK_DOWN) {
            n = -1;
            sign = 1;
        } else if (kcode == KeyEvent.VK_UP) {
            n = 1;
            sign = 1;
        } else if (kcode == KeyEvent.VK_ESCAPE) {
            n = 0;
            sign = -1;
        }
        handleIncrement(n, sign, v);
    }

    private void handleMouseWheelMoved(MouseWheelEvent evt) {
        double v = sens;
        v = (evt.isShiftDown()) ? v * 10 : v;
        v = (evt.isAltDown()) ? v * 100 : v;
        handleIncrement(-evt.getWheelRotation(), 1, v);
    }

    void handleIncrement(int n, double sign, double sv) {
       
        if (sign != 0) {
            if (field != null) {
                String text = field.getText();
                double dv = 0;
                try {
                    dv = parent.getDouble(text);
                } catch (Exception e) {
                    System.out.println(getClass().getName() + ": Error: " + e);
                }
                dv += (n * sv);
                dv *= sign;
                dv = Math.min(dmax, dv);
                dv = Math.max(dmin, dv);
                String s = "" + parent.formatNum(dv);
                field.setText(s);

            } else if (box != null) {
                int v = box.getSelectedIndex();
                v += n;
                int top = box.getItemCount();
                v = (v < 0)?0:v;
                v = (v >= top) ? top - 1 : v;
                box.setSelectedIndex(v);
            }
            if (parent != null) {
                if(field == parent.sv_noiseLevelTextField
                        || field == parent.sv_carrierTextField
                        || field == parent.sv_modPercentTextField
                        || field == parent.sv_modFreqTextField
                        || box == parent.sv_lineWidthComboBox
                        ) {
                    parent.adjustControls();
                }
                else {
                parent.readControls(field == parent.sv_sampleRateTextField);
                }
            }
        }
    }
}
