/*
 * Decompiled with CFR 0.152.
 */
package hdtvtestpattern;

import hdtvtestpattern.ImagePanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JFrame;

public final class HDTVTestPattern
extends JFrame {
    String version = "2.0";
    boolean borderless = true;
    Dimension screenSize;
    Dimension appSize;
    ImagePanel imagePanel;
    String[] instructions;

    public HDTVTestPattern(String[] args) {
        this.setInstructions();
        this.imagePanel = new ImagePanel(this);
        this.add(this.imagePanel);
        if (args.length > 0 && args[0].equals("-f")) {
            this.saveImageFile(this.imagePanel);
        }
        if (this.borderless) {
            this.setAlwaysOnTop(true);
            this.setUndecorated(true);
            this.setResizable(false);
        }
        this.initComponents();
        this.manageFullScreen(true);
    }

    private void saveImageFile(ImagePanel imagePanel) {
        int width = 1920;
        int height = 1080;
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g = bi.createGraphics();
        imagePanel.renderPattern(g, width, height, false);
        try {
            ImageIO.write((RenderedImage)bi, "PNG", new File(this.getClass().getSimpleName() + ".png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void manageFullScreen(boolean full) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        if (full) {
            if (!this.borderless) {
                this.setSize(640, 480);
            } else {
                graphicsDevice.setFullScreenWindow(this);
            }
        } else {
            graphicsDevice.setFullScreenWindow(null);
        }
        this.requestFocusInWindow();
        this.setVisible(true);
    }

    protected void dismiss() {
        this.manageFullScreen(false);
        this.close();
    }

    private void setInstructions() {
        this.instructions = new String[]{"HDTV Flat-panel Test Pattern | Copyright 2011, P. Lutus | http://arachnoid.com/HDTVTestPattern", "Display dimensions: %dx%d pixels.", "Basic Settings (before fine-tuning to satisfy personal taste):", ">This image has a white border. If you don't see it, set your panel's display area to \"full pixel\" mode (no overscan).", ">Adjust the \"Brightness\" control so the levels to the left of the \"Black Reference\" line can't be distinguished (or black).", ">Adjust the \"Contrast\" or \"Picture\" control so only the white levels to the right of the \"White Reference\" line can't be distinguished (or white).", ">Adjust the \"Color\" control so only the color levels to the right of the \"White Reference\" line can't be distinguished.", ">Adjust the \"Tint\" or \"Hue\" control to mid-range (preferred), or so the yellow color bar actually looks yellow.", ">To exit, press any key or click your mouse."};
    }

    private void close() {
        this.dispose();
        System.exit(0);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.setBackground(new Color(0, 0, 0));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                HDTVTestPattern.this.formMouseClicked(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                HDTVTestPattern.this.formKeyPressed(evt);
            }
        });
        this.pack();
    }

    private void formKeyPressed(KeyEvent evt) {
        this.dismiss();
    }

    private void formMouseClicked(MouseEvent evt) {
        this.dismiss();
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.setProperty("awt.useSystemAAFontSettings", "on");
                System.setProperty("swing.aatext", "true");
                new HDTVTestPattern(args).setVisible(true);
            }
        });
    }
}

