/*
 * Decompiled with CFR 0.152.
 */
package jdbclient;

import java.awt.Rectangle;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jdbclient.Configurable;
import jdbclient.MutableDouble;

public final class ConfigManager {
    String appName;
    String lineSep;
    String fileSep;
    String userDir;
    String userPath;
    String initPath;
    String fieldPrefix = "sv_";
    JFrame parent;
    TreeMap<String, Field> fields;

    public ConfigManager() {
    }

    public ConfigManager(JFrame parent) {
        this.parent = parent;
        this.lineSep = System.getProperty("line.separator");
        this.fileSep = System.getProperty("file.separator");
        this.appName = parent.getClass().getSimpleName();
        this.userDir = System.getProperty("user.home");
        this.userPath = this.userDir + this.fileSep + "." + this.appName;
        this.initPath = this.userPath + this.fileSep + this.appName + ".ini";
        this.setup();
    }

    private void setup() {
        Field[] fieldArray;
        this.fields = new TreeMap();
        for (Field f : fieldArray = this.parent.getClass().getDeclaredFields()) {
            String name = f.getName();
            if (!name.matches("^" + this.fieldPrefix + ".*")) continue;
            this.fields.put(name, f);
        }
    }

    public void read() {
        String data = this.readTextFile(this.initPath, this.lineSep);
        if (data.length() > 0) {
            for (String item : data.split(this.lineSep)) {
                String[] lFields = item.split(" = ", 2);
                if (lFields.length <= 1) continue;
                this.readWriteField(lFields[0].trim(), lFields[1].trim());
            }
        }
    }

    public void write() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Field> e : this.fields.entrySet()) {
            String s = String.format("%s = %s%s", e.getKey(), this.readWriteField(e.getKey(), null), this.lineSep);
            sb.append(s);
        }
        this.writeTextFile(this.initPath, sb.toString());
    }

    private int minmax(int n, int low, int high) {
        n = Math.min(n, high - 1);
        n = Math.max(n, low);
        return n;
    }

    String readWriteField(String name, String value) {
        try {
            boolean write;
            Class<?> pc = this.parent.getClass();
            Field f = pc.getDeclaredField(name);
            Object obj = f.get(this.parent);
            String classType = f.getType().toString();
            classType = classType.replaceFirst(".*\\.(.*)", "$1");
            boolean bl = write = value != null;
            if (write) {
                value = value.trim();
            }
            switch (classType) {
                case "int": {
                    if (write) {
                        f.setInt(this.parent, Integer.parseInt(value));
                        break;
                    }
                    value = "" + f.getInt(this.parent);
                    break;
                }
                case "long": {
                    if (write) {
                        f.setLong(this.parent, Long.parseLong(value));
                        break;
                    }
                    value = "" + f.getLong(this.parent);
                    break;
                }
                case "double": {
                    if (write) {
                        f.setDouble(this.parent, Double.parseDouble(value));
                        break;
                    }
                    value = "" + f.getDouble(this.parent);
                    break;
                }
                case "MutableDouble": {
                    if (write) {
                        ((MutableDouble)obj).v = Double.parseDouble(value);
                        break;
                    }
                    value = "" + ((MutableDouble)obj).v;
                    break;
                }
                case "boolean": {
                    if (write) {
                        f.setBoolean(this.parent, value.equals("true"));
                        break;
                    }
                    value = "" + f.getBoolean(this.parent);
                    break;
                }
                case "String": {
                    if (write) {
                        f.set(this.parent, value);
                        break;
                    }
                    value = (String)f.get(this.parent);
                    break;
                }
                case "Rectangle": {
                    if (write) {
                        Rectangle r = this.parseRectangle(value);
                        if (r != null) {
                            f.set(this.parent, r);
                        }
                        break;
                    }
                    value = f.get(this.parent).toString();
                    break;
                }
                case "JRadioButton": {
                    JRadioButton button = (JRadioButton)obj;
                    if (write) {
                        button.setSelected(value.equals("true"));
                        break;
                    }
                    value = "" + button.isSelected();
                    break;
                }
                case "JCheckBox": {
                    JCheckBox cb = (JCheckBox)obj;
                    if (write) {
                        cb.setSelected(value.equals("true"));
                        break;
                    }
                    value = "" + cb.isSelected();
                    break;
                }
                case "JTextField": {
                    JTextField tf = (JTextField)obj;
                    if (write) {
                        tf.setText(value);
                        break;
                    }
                    value = tf.getText();
                    break;
                }
                case "JComboBox": {
                    if (obj instanceof JComboBox) {
                        JComboBox box = (JComboBox)obj;
                        if (write) {
                            int n = Integer.parseInt(value);
                            n = this.minmax(n, 0, box.getItemCount());
                            box.setSelectedIndex(n);
                            break;
                        }
                        value = "" + box.getSelectedIndex();
                    }
                    break;
                }
                case "JSpinner": {
                    JSpinner jsp = (JSpinner)obj;
                    if (write) {
                        jsp.setValue(Integer.parseInt(value));
                        break;
                    }
                    value = "" + jsp.getValue();
                    break;
                }
                case "JSlider": {
                    JSlider jsl = (JSlider)obj;
                    if (write) {
                        jsl.setValue(Integer.parseInt(value));
                        break;
                    }
                    value = "" + jsl.getValue();
                    break;
                }
                case "JTabbedPane": {
                    JTabbedPane tp = (JTabbedPane)obj;
                    if (write) {
                        int n = Integer.parseInt(value);
                        n = this.minmax(n, 0, tp.getTabCount());
                        tp.setSelectedIndex(n);
                        break;
                    }
                    value = "" + tp.getSelectedIndex();
                    break;
                }
                case "JFrame": {
                    JFrame jf = (JFrame)obj;
                    if (write) {
                        Rectangle r = this.parseRectangle(value);
                        if (r != null) {
                            jf.setBounds(r);
                        }
                        break;
                    }
                    value = "" + jf.getBounds();
                    break;
                }
                default: {
                    if (obj instanceof Configurable) {
                        if (write) {
                            ((Configurable)obj).fromString(value);
                            break;
                        }
                        value = obj.toString();
                        break;
                    }
                    System.out.println(this.getClass().getName() + ": cannot decode value for " + classType + " (" + name + ")");
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            System.out.println(this.getClass().getName() + ":readWriteField: \"" + name + "\": " + e);
        }
        return value;
    }

    Rectangle parseRectangle(String value) {
        ArrayList<Integer> vi = new ArrayList<Integer>();
        Rectangle rect = null;
        try {
            String s = value.replaceFirst("^.*x=([-|\\d]+).*y=([-|\\d]+).*width=([-|\\d]+).*height=([-|\\d]+).*$", "$1,$2,$3,$4");
            for (String is : s.split(",")) {
                vi.add(Integer.parseInt(is));
            }
            Iterator it = vi.iterator();
            rect = new Rectangle((Integer)it.next(), (Integer)it.next(), (Integer)it.next(), (Integer)it.next());
        }
        catch (Exception e) {
            System.out.println(this.getClass().getName() + ": error: " + e);
        }
        return rect;
    }

    public String readTextFile(String path, String lineSep) {
        String result = "";
        try {
            result = new Scanner(new File(path)).useDelimiter("\\Z").next();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void writeTextFile(String path, String data) {
        try (PrintWriter out = new PrintWriter(new File(path));){
            out.write(data);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private void p(String s) {
        System.out.println(s);
    }
}

