#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os, sys, re, datetime

sys.path.append('/usr/local/bin')

from common_functions import *
  
launch_in_konsole()

path = get_path()

#genprog="/netbackup/Wine_link_directory/drive_c/Program Files (x86)/Inno Setup 5/Compil32.exe"

project='JDBClient'

print('NOTE: The %s help file HTML source is located here, and the Web version is a copy. Always edit the local file.' % project)

print('Please make sure the project is fully up to date. All class files must be current.')

if confirm("Okay to proceed"):

  # get version

  data = read_file('/netbackup/data/java2/JDBClient/src/jdbclient/JDBClient.java')

  version = re.sub('(?s).*VERSION\s*=\s*\"(.*?)\".*','\\1',data)

  if(len(version) == 0):
    print('No version number available, quitting.')
    exit_reply()
    quit()
    
  write_file('version.txt',version)

  appname=project

  fullname=project + ' ' + version
  
  print('Project: %s' % fullname)

  # create manifest file

  data = 'Class-Path: .\nMain-Class: %s.%s\n' % (project.lower(),project)

  write_file('manifest.txt',data)

  # create JAR file

  print('Building %s JAR file ...' % project)

  binpath1='../build/classes/'
  
  # the linked classes must be binaries
  
  binpath2='../jdbc_libraries/mysql-connector-java-5.1.44-bin/'
  
  # copy jdbc:mysql class files into path
  
  os.system('rsync -av %s %s' % (binpath2,binpath1)) 

  os.system('jar cmf manifest.txt %s.jar -C %s .' % (project,binpath1))
  
  #os.system('jar uf %s.jar -C %s .' % (project,binpath2))

  os.system('chmod +x %s' % (project + '.jar'))

  print('Building %s source archive file ...' % project)

  os.system('tar -cjf %s_source.tar.bz2 ..' % (project))
  
  # windows executable

  print('Building %s Windows executable install program ...' % project)

  os.system('sed s/_APPNAME/%s/ < ../../AAA_NSIS_notes/GenericMaster.nsi > %s.nsi' % (appname,appname))
  
  os.system('sed s/_APPNAME/%s/ < ../../AAA_NSIS_notes/appname.bat > %s.bat' % (appname,appname))
  
  os.system('unix2dos %s.bat' % (appname))
  
  os.system('makensis %s.nsi > /dev/null 2>&1' % (project))

  #os.system('mv Output/setup.exe %s.exe' % (project))

  print('Moving %s files to destination ...' % project)

  dest='/netbackup/data/Network/arachnoid/%s' % project

  os.system('cp -p %s.jar %s.png %s_source.tar.bz2 %s.exe %s/resources' % (project,project,project,project,dest))
  dpath = '../src/%s/help/JDBClientHelp.html' % (project.lower())

  print(dpath)
  data = read_file(dpath)
  
  data = re.sub(' -- ',' &mdash; ',data)

  data = re.sub(r'\(version\)',version,data)

  data = re.sub(r'\(userdir\)','(user directory)',data)

  data = re.sub('<!--\s*UTF8 MODIFIER\s*-->','<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>',data)
    
  newcss = """
  body {
    font-family: Verdana, Tahoma, Helvetica, Arial;
  }
  table {
  background:#fffff0;
  }
  table,table tr td,table tr th {
  border: 1px solid #000000;
  border-collapse:collapse;
  }

.dbclient tr.row0 { background:#bfdeb9; }
.dbclient tr.row1 { background:#f6ffda; }

tr.headline {
  text-align:center;
  font-weight:bold;
  background:#96b183;
}  
  
  .article_subtopic {
  font-weight:bold;
}
  """
  
  data = re.sub('(?s)(<style type="text/css">)(.*?)(</style>)','\\1'+newcss+'\\3',data)
  
  # data = re.sub('border-width:1px;','border-width:0px;',data)
  
  #data = re.sub('file:/opticalraytracer/help/','',data)

  write_file('%s/help/JDBClientHelp.html' % dest,data)
    
  #subpath = '../src/%s/help' % (project.lower())
  
  #os.system('rsync -av %s/*.txt %s/*.png %s/help' % (subpath,subpath,dest))

  os.system('rsync -av ../src/%s/icons/ %s/icons/' % (project.lower(),dest))
  
  os.system('rsync -av version.txt %s/resources/' % (dest))

exit_reply()
