// ***************************************************************************
// *   Copyright (C) 2012 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************
package jdbclient;

import java.awt.event.KeyEvent;

/**
 *
 * @author lutusp
 */
final public class MyJTextField extends javax.swing.JTextField {

    JDBClient parent;
    static final long serialVersionUID = 674932;
    QueryProcessor queryResult;

    public MyJTextField(JDBClient p, QueryProcessor qr) {
        super();
        parent = p;
        queryResult = qr;
        setup();
    }

    /* public MyQueryTextField(JDBClient p, String content) {
     super(content);
     parent = p;
     setup();
     }*/
    private void setup() {
        setFont(parent.baseFont);
        addKeyListener(new java.awt.event.KeyAdapter() {
            @Override
            public void keyReleased(java.awt.event.KeyEvent evt) {
                testKey(evt);
            }
        });
    }

    private void testKey(java.awt.event.KeyEvent evt) {
        //if ((evt.getModifiers() & KeyEvent.SHIFT_MASK) != 0) {
        switch (evt.getKeyCode()) {
            case KeyEvent.VK_ENTER:
                parent.formatRunQuery();
                break;
            case KeyEvent.VK_UP:
                queryResult.vtab(this, -1);
                break;
            case KeyEvent.VK_DOWN:
                queryResult.vtab(this, 1);
                break;
        }
        //}
    }
}
