// ***************************************************************************
// *   Copyright (C) 2012 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************
package jdbclient;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

/**
 *
 * @author lutusp
 */
final public class MySplitPane extends JSplitPane {

    // this class solves two problems:
    // 1. shows a tooptip above a container, not normally possible
    // 2. allows user-adjustment of the divider location
    // without ambiguity about the source of the change
    JDBClient parent;
    static final long serialVersionUID = 67749;
    BasicSplitPaneDivider divider = null;
    JSplitPane pane;
    private HashMap<JComponent, Popup> PopupMap;

    public MySplitPane(JDBClient p) {
        super();
        parent = p;
        setup();
    }

    private void setup() {
        pane = this;
        PopupMap = new HashMap<>();
        divider = ((BasicSplitPaneUI) getUI()).getDivider();

        divider.addMouseListener(new MouseAdapter() {
            @Override
            public void mousePressed(MouseEvent e) {
                Popup pop = PopupMap.get(pane);
                if (pop != null) {
                    pop.hide();
                    PopupMap.remove(pane);
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                showToolTip(pane, evt.getXOnScreen(), evt.getYOnScreen());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Popup pop = PopupMap.get(pane);
                if (pop != null) {
                    pop.hide();
                    PopupMap.remove(pane);
                }
            }
        });

        // this actually adjusts the divider, which was
        // the point of this exercise

        divider.addMouseMotionListener(new MouseAdapter() {
            @Override
            public void mouseDragged(MouseEvent evt) {
                parent.adjustUserDividerPosition();
            }
        });
    }

    public void showToolTip(final JComponent comp, int x, int y) {
        Popup pop = PopupMap.get(comp);
        if (pop == null) {
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            JToolTip tooltip = comp.createToolTip();
            tooltip.setTipText(comp.getToolTipText());
            pop = popupFactory.getPopup(comp, tooltip, x, y + 12);
            PopupMap.put(comp, pop);
            pop.show();
        }
    }

    protected static void p(String s) {
        System.out.println(s);
    }
}
