/*
 * Decompiled with CFR 0.152.
 */
package jnx;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jnx.JNX;
import jnx.TextFieldController;
import jnx.ToggleButtonController;

public final class ScopePanel
extends JPanel {
    JNX parent = null;
    int scope_size;
    int scope_sync_max;
    InternalScopePanel scope_pane;
    double vscalea = -1.0;
    double vscaleb = 1.0;
    double hscale = 0.1;
    double hcal = 1.0;
    String h_unit = "Sec";
    double gain_scale = 0.5;
    int traces = 4;
    int scope_pointer = 0;
    int sync_phase = 1;
    int sync_count = 0;
    double old_sync = 0.0;
    double[] inputa = null;
    double[] inputb = null;
    double[] outputa = null;
    double[] outputb = null;
    boolean spectrum_trace = false;
    boolean dual_trace = true;
    TextFieldController horizontal_control;
    TextFieldController vertical_control;
    ToggleButtonController sync_with_signal;
    Color zero_line_color;
    private JPanel control_panel;
    private JTextField hscale_textfield;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel mouse_pos_label;
    private JCheckBox sync_checkbox;
    private JTextField vscale_textfield;

    public ScopePanel(JNX p, String title, boolean spec) {
        this.parent = p;
        this.initComponents();
        this.spectrum_trace(spec);
        this.zero_line_color = new Color(0.2f, 0.5f, 0.8f);
        TitledBorder tb = (TitledBorder)this.getBorder();
        tb.setTitle(title);
        this.scope_pane = new InternalScopePanel();
        this.add(this.scope_pane);
        this.horizontal_control = new TextFieldController(this.hscale_textfield, "100", 1000.0);
        this.vertical_control = new TextFieldController(this.vscale_textfield, "100", 1000.0);
        this.sync_with_signal = new ToggleButtonController(this.sync_checkbox, false);
    }

    public void spectrum_trace(boolean v) {
        this.spectrum_trace = v;
        if (this.spectrum_trace) {
            this.sync_checkbox.setEnabled(!this.spectrum_trace);
            this.gain_scale = 2.0;
            this.vscalea = 0.0;
            this.h_unit = "Hz";
        }
    }

    public void reset_scope_size() {
        this.scope_size = (int)(this.hscale * (double)this.parent.receiver.sample_rate);
        this.hcal = (double)this.scope_size / (double)this.parent.receiver.sample_rate;
        this.reset_scope_inner();
    }

    public void reset_scope_params(int size) {
        this.scope_size = size;
        this.reset_scope_inner();
    }

    private void reset_scope_inner() {
        this.scope_pointer = 0;
        this.inputa = new double[this.scope_size];
        this.inputb = new double[this.scope_size];
        this.outputa = new double[this.scope_size];
        this.outputb = new double[this.scope_size];
        this.scope_sync_max = this.scope_size * 3 / 4;
    }

    public void set_hcal(double v) {
        this.hcal = v;
    }

    public void write_value(double a) {
        this.write_value2(a, 0.0, false);
    }

    public void write_value(double a, double b) {
        this.write_value2(a, b, true);
    }

    public void write_value2(double a, double b, boolean dual) {
        this.dual_trace = dual;
        if (this.inputa != null) {
            if (this.sync_phase < 1) {
                switch (this.sync_phase) {
                    case -1: {
                        this.old_sync = a;
                        ++this.sync_phase;
                        break;
                    }
                    case 0: {
                        if (!(a > 0.0 && this.old_sync < 0.0) && this.sync_count <= this.scope_sync_max) break;
                        ++this.sync_phase;
                    }
                }
                this.old_sync = a;
                ++this.sync_count;
            }
            if (this.sync_phase == 1) {
                this.inputa[this.scope_pointer] = a;
                this.inputb[this.scope_pointer] = b;
                ++this.scope_pointer;
                if (this.scope_pointer >= this.scope_size) {
                    this.scope_pointer = 0;
                    System.arraycopy(this.inputa, 0, this.outputa, 0, this.scope_size);
                    System.arraycopy(this.inputb, 0, this.outputb, 0, this.scope_size);
                    this.repaint();
                    this.sync_count = 0;
                    this.sync_phase = this.sync_with_signal.get_value() ? -1 : 1;
                    this.check_controls();
                }
            }
        }
    }

    private void check_controls() {
        double v;
        int ss;
        if (!this.spectrum_trace && (ss = (int)((v = (v = this.horizontal_control.get_pct_dvalue() * 0.1) < 0.01 ? 0.01 : v) * (double)this.parent.receiver.sample_rate)) != this.scope_size) {
            this.hscale = v;
            this.reset_scope_size();
        }
    }

    public void write_array(double[] data) {
        this.dual_trace = false;
        System.arraycopy(data, 0, this.outputa, 0, this.scope_size);
        this.repaint();
    }

    private double ntrp(double x, double xa, double xb, double ya, double yb) {
        return (x - xa) * (yb - ya) / (xb - xa) + ya;
    }

    private void initComponents() {
        this.control_panel = new JPanel();
        this.mouse_pos_label = new JLabel();
        this.jLabel1 = new JLabel();
        this.hscale_textfield = new JTextField();
        this.jLabel2 = new JLabel();
        this.vscale_textfield = new JTextField();
        this.sync_checkbox = new JCheckBox();
        this.setBorder(BorderFactory.createTitledBorder("Title"));
        this.setLayout(new BorderLayout());
        this.control_panel.setLayout(new GridBagLayout());
        this.mouse_pos_label.setFont(new Font("Monospaced", 1, 12));
        this.mouse_pos_label.setText("         ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.control_panel.add((Component)this.mouse_pos_label, gridBagConstraints);
        this.jLabel1.setText("H Scale:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.control_panel.add((Component)this.jLabel1, gridBagConstraints);
        this.hscale_textfield.setHorizontalAlignment(4);
        this.hscale_textfield.setText("100.0");
        this.hscale_textfield.setMaximumSize(new Dimension(80, 19));
        this.hscale_textfield.setMinimumSize(new Dimension(80, 19));
        this.hscale_textfield.setPreferredSize(new Dimension(80, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.control_panel.add((Component)this.hscale_textfield, gridBagConstraints);
        this.jLabel2.setText("V Scale %:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.control_panel.add((Component)this.jLabel2, gridBagConstraints);
        this.vscale_textfield.setHorizontalAlignment(4);
        this.vscale_textfield.setText("100.0");
        this.vscale_textfield.setMaximumSize(new Dimension(80, 19));
        this.vscale_textfield.setMinimumSize(new Dimension(80, 19));
        this.vscale_textfield.setPreferredSize(new Dimension(80, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.control_panel.add((Component)this.vscale_textfield, gridBagConstraints);
        this.sync_checkbox.setSelected(true);
        this.sync_checkbox.setText("Sync");
        this.sync_checkbox.setToolTipText("Try to synchronize with data");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.control_panel.add((Component)this.sync_checkbox, gridBagConstraints);
        this.add((Component)this.control_panel, "South");
    }

    class InternalScopePanel
    extends JPanel {
        public InternalScopePanel() {
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseMoved(MouseEvent evt) {
                    InternalScopePanel.this.track_mouse(evt);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    InternalScopePanel.this.handle_mouse_click(evt);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mouseExited(MouseEvent evt) {
                    InternalScopePanel.this.mouse_exited(evt);
                }
            });
        }

        private void handle_mouse_click(MouseEvent evt) {
            if (ScopePanel.this.parent.debug && evt.getButton() == 3) {
                try {
                    int w = 250;
                    int h = 125;
                    BufferedImage bi = new BufferedImage(w, h, 2);
                    Graphics2D g = bi.createGraphics();
                    this.paint_scope(w, h, g);
                    int image_num = 0;
                    File f = null;
                    do {
                        f = new File(ScopePanel.this.parent.data_path + "/" + "image" + image_num + ".png");
                        ++image_num;
                    } while (f.exists());
                    ImageIO.write((RenderedImage)bi, "PNG", f);
                    ++image_num;
                }
                catch (Exception e) {
                    System.out.println(e);
                    e.printStackTrace();
                }
            }
        }

        private void track_mouse(MouseEvent evt) {
            double x = (double)evt.getX() * ScopePanel.this.hcal / (double)this.getWidth();
            double y = 1.0 - (double)evt.getY() / (double)this.getHeight();
            y = (y * (ScopePanel.this.vscaleb - ScopePanel.this.vscalea) + ScopePanel.this.vscalea) / (ScopePanel.this.vertical_control.get_pct_dvalue() * ScopePanel.this.gain_scale);
            String s = String.format("Mouse cursor: x = %.2f %s, y = %.2f", x, ScopePanel.this.h_unit, y);
            ScopePanel.this.mouse_pos_label.setText(s);
        }

        private void mouse_exited(MouseEvent evt) {
            ScopePanel.this.mouse_pos_label.setText("         ");
        }

        public void paintComponent(Graphics g) {
            Rectangle r = g.getClipBounds();
            int width = r.width;
            int height = r.height;
            this.paint_scope(width, height, g);
        }

        private void paint_scope(int width, int height, Graphics gg) {
            double gain = ScopePanel.this.vertical_control.get_pct_dvalue() * ScopePanel.this.gain_scale;
            if (ScopePanel.this.parent != null && ScopePanel.this.outputa != null) {
                Graphics2D g = (Graphics2D)gg;
                g.setColor(Color.black);
                g.fillRect(0, 0, width, height);
                this.draw_grid(width, height, g);
                if (ScopePanel.this.dual_trace) {
                    this.draw_trace(ScopePanel.this.outputa, gain, width, height - height / 2, g);
                    this.draw_trace(ScopePanel.this.outputb, gain, width, height + height / 2, g);
                } else {
                    this.draw_trace(ScopePanel.this.outputa, gain, width, height, g);
                }
            }
        }

        private void draw_trace(double[] data, double gain, int horiz, int vert, Graphics2D g) {
            int ox = 0;
            int oy = 0;
            int len = data.length;
            int py = (int)ScopePanel.this.ntrp(0.0, ScopePanel.this.vscalea, ScopePanel.this.vscaleb, vert, 0.0);
            g.setColor(ScopePanel.this.zero_line_color);
            g.drawLine(0, py, horiz, py);
            g.setColor(Color.green);
            for (int i = 0; i < len; ++i) {
                double y = data[i] * gain;
                int px = (int)ScopePanel.this.ntrp(i, 0.0, len, 0.0, horiz);
                py = (int)ScopePanel.this.ntrp(y, ScopePanel.this.vscalea, ScopePanel.this.vscaleb, vert, 0.0);
                if (i != 0) {
                    g.drawLine(ox, oy, px, py);
                }
                ox = px;
                oy = py;
            }
        }

        private void draw_grid(int w, int h, Graphics2D g) {
            int s = 8;
            double v = 0.0;
            g.setColor(new Color(0.5f, 0.5f, 0.3f));
            Stroke old_stroke = g.getStroke();
            g.setStroke(new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f}, 0.0f));
            for (int y = 0; y <= s; ++y) {
                v = (double)y / (double)s;
                int pv = (int)(v * (double)h);
                g.drawLine(0, pv, w, pv);
                pv = (int)(v * (double)w);
                g.drawLine(pv, 0, pv, h);
            }
            g.setStroke(old_stroke);
        }
    }
}

