/*
 * Decompiled with CFR 0.152.
 */
package jnx;

import jnx.Complex;
import jnx.FFT;
import jnx.JNX;
import jnx.ScopePanel;

public class SpectrumDisplayManager {
    JNX parent;
    FFT fft;
    ScopePanel scope_panel;
    double hfactor = 8.0;
    int array_size = 1000;
    int fft_array_size = 2048;
    int array_mult_factor = 5;
    double array_ratio;
    int rate = 0;
    double[] real_data;
    int src_pointer = 0;
    int dest_pointer = 0;

    public SpectrumDisplayManager(JNX p, ScopePanel sp) {
        this.scope_panel = sp;
        this.parent = p;
        this.fft = new FFT();
        this.reset_params(this.array_size);
    }

    private void reset_params(int as) {
        this.array_size = as;
        int p = (int)(Math.log(this.array_size) / Math.log(2.0) + 1.0);
        int fft_as = (int)Math.pow(2.0, p);
        if (fft_as != this.fft_array_size) {
            this.fft_array_size = fft_as;
            this.fft.initialize(this.fft_array_size, false);
        }
        this.array_ratio = (double)this.fft_array_size / (double)this.array_size;
        this.real_data = new double[this.array_size / 2];
        this.scope_panel.reset_scope_params(this.array_size / 2);
    }

    public void add_data(double v) {
        this.rate = (int)((double)this.parent.receiver.sample_rate / this.hfactor);
        this.scope_panel.set_hcal((double)this.array_size * this.hfactor / 2.0);
        if (this.src_pointer >= this.rate) {
            this.fft.fft1();
            Complex[] data = this.fft.outputArray();
            int len = this.real_data.length;
            for (int i = 0; i < len; ++i) {
                this.real_data[i] = data[i].mag();
            }
            this.scope_panel.write_array(this.real_data);
            this.src_pointer = 0;
            this.update_controls();
        } else {
            this.dest_pointer = (int)((double)(this.src_pointer * this.array_size) * this.array_ratio) / this.rate;
            this.fft.set_value(this.dest_pointer, v);
            ++this.src_pointer;
        }
    }

    private void update_controls() {
        int p = (int)this.scope_panel.horizontal_control.get_dvalue();
        p = Math.max(1, p);
        if ((p *= this.array_mult_factor) != this.array_size) {
            this.reset_params(p);
        }
    }
}

