/***************************************************************************
 *   Copyright (C) 2011 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
package jnx;

import java.util.*;

/**
 *
 * @author lutusp
 */
final public class CCIR476 {

    private HashMap<Integer, Integer> code_figs, code_ltrs, ltrs_code, figs_code;
    private HashSet<Integer> valid_codes;
    private boolean shift;

    // generated by /netbackup/data/python_projects/ccir476/./decode_ccir476.py
private char[][] ltrs = {
    //0    1    2    3    4    5    6    7    8    9    a    b    c    d    e    f
    {'_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_'}, // 0
    {'_', '_', '_', '_', '_', '_', '_', 'J', '_', '_', '_', 'F', '_', 'C', 'K', '_'}, // 1
    {'_', '_', '_', '_', '_', '_', '_', 'W', '_', '_', '_', 'Y', '_', 'P', 'Q', '_'}, // 2
    {'_', '_', '_', '_', '_', 'G', '_', '_', '_', 'M', 'X', '_', 'V', '_', '_', '_'}, // 3
    {'_', '_', '_', '_', '_', '_', '_', 'A', '_', '_', '_', 'S', '_', 'I', 'U', '_'}, // 4
    {'_', '_', '_', 'D', '_', 'R', 'E', '_', '_', 'N', '_', '_', ' ', '_', '_', '_'}, // 5
    {'_', '_', '_', 'Z', '_', 'L', '_', '_', '_', 'H', '_', '_', '\n', '_', '_', '_'}, // 6
    {'_', 'O', 'B', '_', 'T', '_', '_', '_', '\r', '_', '_', '_', '_', '_', '_', '_'} // 7
};
private char[][] figs = {
    //0    1    2    3    4    5    6    7    8    9    a    b    c    d    e    f
    {'_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_'}, // 0
    {'_', '_', '_', '_', '_', '_', '_', '\'', '_', '_', '_', '!', '_', ':', '(', '_'}, // 1
    {'_', '_', '_', '_', '_', '_', '_', '2', '_', '_', '_', '6', '_', '0', '1', '_'}, // 2
    {'_', '_', '_', '_', '_', '&', '_', '_', '_', '.', '/', '_', ';', '_', '_', '_'}, // 3
    {'_', '_', '_', '_', '_', '_', '_', '-', '_', '_', '_', '\07', '_', '8', '7', '_'}, // 4
    {'_', '_', '_', '$', '_', '4', '3', '_', '_', ',', '_', '_', ' ', '_', '_', '_'}, // 5
    {'_', '_', '_', '"', '_', ')', '_', '_', '_', '#', '_', '_', '\n', '_', '_', '_'}, // 6
    {'_', '9', '?', '_', '5', '_', '_', '_', '\r', '_', '_', '_', '_', '_', '_', '_'} // 7
};


    public CCIR476() {
        code_figs = new HashMap<Integer, Integer>();
        code_ltrs = new HashMap<Integer, Integer>();
        ltrs_code = new HashMap<Integer, Integer>();
        figs_code = new HashMap<Integer, Integer>();
        valid_codes = new HashSet<Integer>();
        shift = false;
        int x, y;
        for (int code = 0; code < 128; code++) {
            if (check_bits(code)) {
                valid_codes.add(code);
                x = code & 0xf;
                y = code >> 4;
                int figv = figs[y][x];
                int ltrv = ltrs[y][x];
                if ((char) figv != '_') {
                    code_figs.put(code, figv);
                    figs_code.put(figv, code);
                }
                if ((char) ltrv != '_') {
                    code_ltrs.put(code, ltrv);
                    ltrs_code.put(ltrv, code);
                }
            }
        }
    }

    public boolean get_shift() {
        return shift;
    }

    public boolean check_valid(int code) {
        return valid_codes.contains(code);
    }

    public int char_to_code(int ch, boolean ex_shift) {
        ch = Character.toUpperCase(ch);
        // default: return -ch
        int code = -ch;
        // avoid unnececessary shifts
        if (ex_shift && figs_code.containsKey(ch)) {
            code = figs_code.get(ch);
        } else if (!ex_shift && ltrs_code.containsKey(ch)) {
            code = ltrs_code.get(ch);
        } else {
            if (figs_code.containsKey(ch)) {
                shift = true;
                code = figs_code.get(ch);
            } else if (ltrs_code.containsKey(ch)) {
                shift = false;
                code = ltrs_code.get(ch);
            }
        }
        return code;
    }

    public int code_to_char(int code, boolean shift) {
        // default: return negated code
        int ch = -code;
        HashMap<Integer, Integer> target = (shift) ? code_figs : code_ltrs;
        if (target.containsKey(code)) {
            ch = target.get(code);
        }
        //System.out.println(String.format("code = %x, char = %d,%c",code,ch,(char)ch));
        return ch;
    }

    public static boolean check_bits(int v) {
        int bc = 0;
        while (v != 0) {
            bc++;
            v &= v - 1;
        }
        return bc == 4;
    }
}
