/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * MessageFilterDialog.java
 *
 * Created on Mar 15, 2011, 2:48:30 PM
 */
package jnx;

import javax.swing.*;
import java.awt.*;
import java.util.*;

/**
 *
 * @author lutusp
 */
public class MessageFilterDialog extends javax.swing.JDialog {

    String[][] nav_msgs = new String[][]{
        {"A", "Navigational warnings", "Navigational warnings"},
        {"B", "Meteorological warnings", "Meteorological warnings"},
        {"C", "Ice reports", "Ice reports"},
        {"D", "Search & rescue / pirate warnings", "Search & rescue information, and pirate warnings"},
        {"E", "Meteorological forecasts", "Meteorological forecasts"},
        {"F", "Pilot service messages", "Pilot service messages"},
        {"G", "AIS messages", "AIS messages"},
        {"H", "LORAN messages", "LORAN messages"},
        {"I", "Not used", "Not used"},
        {"J", "SATNAV messages", "SATNAV messages (i.e. GPS or GLONASS)"},
        {"K", "Other navaid messages", "Other electronic navaid messages"},
        {"L", "Navigational warnings", "Navigational warnings - additional to letter A (Should not be rejected by the receiver)"},
        {"T", "Test transmissions", "Test transmissions (UK only - not official)"},
        {"V", "Notice to fishermen", "Notice to fishermen (U.S. only - currently not used)"},
        {"W", "Environmental", "Environmental (U.S. only - currently not used)"},
        {"X", "Special services", "Special services - allocation by IMO NAVTEX Panel"},
        {"Y", "Special services", "Special services - allocation by IMO NAVTEX Panel"},
        {"Z", "No message on hand", "No message on hand"}
    };
    JNX parent;
    HashMap<String,JCheckBox> button_list;

    /** Creates new form MessageFilterDialog */
    public MessageFilterDialog(JNX p, boolean modal) {
        super(p, modal);
        parent = p;
        initComponents();
        setTitle("Select which Navtex messages to accept");
        button_list = new HashMap<String,JCheckBox>();
        int i = 0;
        int col_len = 10;
        while (i + col_len < nav_msgs.length) {
            for (int j = 0; j <= col_len; j += col_len) {
                String tag = nav_msgs[i + j][0];
                JCheckBox b = new JCheckBox(tag + ": " + nav_msgs[i + j][1]);
                b.setToolTipText(nav_msgs[i + j][2]);
                b.setSelected(parent.accepted_navtex_messages.accept(tag));
                button_list.put(tag,b);
                button_panel.add(b);
            }
            i++;
        }
        pack();
        setLocationRelativeTo(parent);
    }

    private void reset_all_buttons(boolean state) {
        for (String s : button_list.keySet()) {
            button_list.get(s).setSelected(state);
        }
        // don't reset this choice
        button_list.get("L").setSelected(true);
    }

    private void close() {
        String selected = "";
        java.util.List<String> keys = new ArrayList<String>(button_list.keySet());
        Collections.sort(keys);
        for (String s : keys) {
            if (button_list.get(s).isSelected()) {
                selected += s;
            }
        }
        parent.accepted_navtex_messages.set_value(selected);
        setVisible(false);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        button_panel = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        select_all_button = new javax.swing.JButton();
        clear_all_button = new javax.swing.JButton();
        close_button = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        button_panel.setLayout(new java.awt.GridLayout(8, 2));
        getContentPane().add(button_panel, java.awt.BorderLayout.CENTER);

        select_all_button.setText("Select All");
        select_all_button.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                select_all_buttonMouseClicked(evt);
            }
        });
        jPanel1.add(select_all_button);

        clear_all_button.setText("Clear All");
        clear_all_button.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                clear_all_buttonMouseClicked(evt);
            }
        });
        jPanel1.add(clear_all_button);

        close_button.setText("Close");
        close_button.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                close_buttonMouseClicked(evt);
            }
        });
        jPanel1.add(close_button);

        getContentPane().add(jPanel1, java.awt.BorderLayout.PAGE_END);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void close_buttonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_close_buttonMouseClicked
        // TODO add your handling code here:
        close();
    }//GEN-LAST:event_close_buttonMouseClicked

    private void clear_all_buttonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_clear_all_buttonMouseClicked
        // TODO add your handling code here:
        reset_all_buttons(false);
    }//GEN-LAST:event_clear_all_buttonMouseClicked

    private void select_all_buttonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_select_all_buttonMouseClicked
        // TODO add your handling code here:
        reset_all_buttons(true);
    }//GEN-LAST:event_select_all_buttonMouseClicked
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel button_panel;
    private javax.swing.JButton clear_all_button;
    private javax.swing.JButton close_button;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JButton select_all_button;
    // End of variables declaration//GEN-END:variables
}
