/*
 * Decompiled with CFR 0.152.
 */
package jrx;

import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import jrx.JRX;
import jrx.MemoryButton;

public final class MemoryFunctions {
    JRX parent;
    String header;

    public MemoryFunctions(JRX p) {
        this.parent = p;
        this.header = "Mnnn = Freq,Mode,Bandwidth,AGC,CTCSS,StepIndex,NB,Preamp,Antenna,Attenuator,Skip";
    }

    protected void dispatch(MouseEvent evt) {
        String jb;
        switch (jb = ((JButton)evt.getSource()).getText()) {
            case "CM": {
                this.writeButtonsToClipboard();
                break;
            }
            case "PM": {
                this.confirmReadButtonsFromClipboard();
                break;
            }
            case "RM": {
                this.confirmReadButtonsFromRadio();
                break;
            }
            case "WM": {
                this.confirmWriteButtonsToRadio();
                break;
            }
            case "EM": {
                this.confirmEraseButtons(this.parent.buttonMap);
            }
        }
    }

    protected void layoutButtons(JPanel panel) {
        this.parent.buttonMap = new TreeMap();
        panel.removeAll();
        panel.setLayout(new GridLayout(20, 20));
        for (int i = 1; i <= this.parent.memoryButtonTotal; ++i) {
            String lbl = String.format("M%03d", i);
            MemoryButton mb = new MemoryButton(lbl, this.parent);
            panel.add(mb);
            this.parent.buttonMap.put(lbl, mb);
        }
    }

    protected void resetButtonColors() {
        for (MemoryButton mb : this.parent.buttonMap.values()) {
            mb.updateState();
        }
    }

    protected void confirmEraseButtons(TreeMap<String, MemoryButton> buttonMap) {
        if (this.parent.askUser("Okay to erase all memory buttons?")) {
            this.eraseButtons(buttonMap);
        }
    }

    protected void eraseButtons(TreeMap<String, MemoryButton> buttonMap) {
        for (MemoryButton mb : buttonMap.values()) {
            mb.reset();
            mb.updateState();
        }
    }

    protected void stringToButtons(String data, TreeMap<String, MemoryButton> buttonMap, String tag) {
        try {
            boolean first = true;
            for (String s : data.split(this.parent.lineSep)) {
                if (first) {
                    if (!s.equals(this.header)) {
                        throw new Exception(String.format("%s contents not a button table for this JRX version.", tag));
                    }
                    first = false;
                    continue;
                }
                String[] array = s.split(" = ");
                if (!buttonMap.containsKey(array[0])) continue;
                buttonMap.get(array[0]).defineFromString(array[1]);
            }
        }
        catch (Exception e) {
            this.parent.tellUser(String.format("Error: %s", e.getMessage()));
        }
    }

    protected String buttonsToString(TreeMap<String, MemoryButton> buttonMap) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.header).append(this.parent.lineSep);
        for (MemoryButton mb : buttonMap.values()) {
            if (mb.frequency < 0L) continue;
            String rec = String.format("%s = %s" + this.parent.lineSep, mb.label, mb.toString());
            sb.append(rec);
        }
        return sb.toString();
    }

    protected void readButtonsFromFile(String buttonFilePath, TreeMap<String, MemoryButton> buttonMap) {
        File f = new File(buttonFilePath);
        if (f.exists()) {
            String data = this.parent.readTextFile(buttonFilePath, this.parent.lineSep);
            this.stringToButtons(data, buttonMap, "file");
        }
    }

    protected void writeButtonsToFile(String buttonFilePath, TreeMap<String, MemoryButton> buttonMap) {
        String result = this.buttonsToString(buttonMap);
        this.parent.writeTextFile(buttonFilePath, result);
    }

    protected void confirmReadButtonsFromClipboard() {
        if (this.parent.askUser("Okay to read all memory buttons from clipboard?")) {
            this.readButtonsFromClipboard();
        }
    }

    protected void readButtonsFromClipboard() {
        String data = this.parent.readFromClipboard();
        this.stringToButtons(data, this.parent.buttonMap, "clipboard");
    }

    protected void writeButtonsToClipboard() {
        String data = this.buttonsToString(this.parent.buttonMap);
        this.parent.writeToClipboard(data);
    }

    protected void confirmReadButtonsFromRadio() {
        if (this.parent.askUser("Okay to read all memory buttons from radio?")) {
            int mem = 0;
            for (MemoryButton mb : this.parent.buttonMap.values()) {
                this.parent.waitMS(200);
                this.parent.p(mb.label);
                String com = String.format("E %d", mem);
                this.parent.sendRadioCom(com, 0, true);
                this.parent.waitMS(200);
                com = String.format("e %d", mem);
                String result = this.parent.sendRadioCom(com, 0, false);
                ++mem;
            }
        }
    }

    protected void confirmWriteButtonsToRadio() {
        if (this.parent.askUser("Okay to write all memory buttons to radio?")) {
            // empty if block
        }
    }

    public void p(String s) {
        this.parent.p(s);
    }
}

