/*
 * Decompiled with CFR 0.152.
 */
package jrx;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import jrx.ControlInterface;
import jrx.JRX;

public final class RWComboBox
extends JComboBox<String>
implements MouseWheelListener,
ActionListener,
ControlInterface {
    JRX parent;
    String prefix;
    String token;
    TreeMap<String, Integer> displayMap;
    TreeMap<Integer, String> reverseDisplayMap;
    TreeMap<String, Integer> useMap;
    TreeMap<Double, Integer> useMapDouble;
    TreeMap<Integer, String> reverseUseMap;
    boolean numericMode = false;
    double errorValue = 1.0E100;
    double oldValue = -1.0;
    double xValueLow = 0.0;
    double xValueHigh = 1.0;
    double yValueLow = 0.0;
    double yValueHigh = 1.0;
    double numSelection = -10.0;
    double oldNumSelection;
    String strSelection = null;
    String oldStrSelection;
    String strFilter = "";
    String oldFilter = "x";
    boolean localInhibit = false;
    boolean needFilter = false;
    boolean needMode = false;
    boolean ctcss = false;
    boolean enabled = false;
    boolean commOK = true;

    public RWComboBox(JRX p, String pre, String t) {
        this.parent = p;
        this.prefix = pre;
        this.token = t;
        if (this.prefix != null) {
            this.ctcss = this.prefix.equals("ctcss");
            this.needFilter = this.prefix.equals("M");
            this.needMode = this.prefix.equals("F");
        }
        this.setup(true);
    }

    private void setup(boolean first) {
        if (first) {
            this.addMouseWheelListener(this);
            this.addActionListener(this);
        }
        this.numericMode = false;
        this.commOK = true;
        this.oldNumSelection = -1.0;
        this.oldStrSelection = "xxx";
        this.oldFilter = "xxx";
        this.displayMap = new TreeMap();
        this.useMap = new TreeMap();
        this.useMapDouble = new TreeMap();
        this.reverseDisplayMap = new TreeMap();
        this.reverseUseMap = new TreeMap();
    }

    public void addListItem(String disp, double use, String suse) {
        int index = this.getItemCount();
        this.useMapDouble.put(use, index);
        this.useMap.put(suse, index);
        this.displayMap.put(disp, index);
        this.reverseDisplayMap.put(index, disp);
        this.reverseUseMap.put(index, suse);
        super.addItem(disp);
    }

    protected void setGenericComboBoxScale(String tag, String search, boolean offOption, boolean numeric) {
        int index;
        boolean old_inhibit;
        block13: {
            this.setup(false);
            old_inhibit = this.parent.inhibit;
            this.parent.inhibit = true;
            index = this.getSelectedIndex();
            if (this.needMode) {
                this.setupFilterCombo();
            } else if (this.parent.radioData != null) {
                try {
                    String[] array;
                    String s = this.parent.radioData.replaceFirst(search, "$1");
                    if (this.parent.comArgs.debug >= 1) {
                        this.parent.p("combo box content: [" + s + "]");
                    }
                    if ((array = s.split("\\s+")) != null) {
                        String is;
                        this.removeAllItems();
                        int n = 0;
                        if (offOption) {
                            is = tag + " off";
                            this.addListItem(is, 0.0, "0");
                            ++n;
                        }
                        for (String ss : array) {
                            double v;
                            is = String.format(tag + " %s", ss);
                            if (numeric) {
                                if (!ss.matches(".*?[0-9.+-]+.*")) break block13;
                                ss = ss.replaceFirst(".*?([0-9.+-]+).*", "$1");
                            }
                            if (this.ctcss) {
                                v = Double.parseDouble(ss);
                                ss = String.format("%.0f", v * 10.0);
                            }
                            v = 0.0;
                            try {
                                v = Double.parseDouble(ss);
                                this.numericMode = true;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            this.addListItem(is, v, ss);
                            ++n;
                        }
                        break block13;
                    }
                    this.comboPlaceholderData();
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                }
            }
        }
        this.setComboBoxIndex(index);
        this.parent.inhibit = old_inhibit;
    }

    private void setupFilterCombo() {
        if (this.parent.radioData != null) {
            this.removeAllItems();
            TreeMap<Long, String> valToKey = new TreeMap<Long, String>();
            valToKey.put(0L, "BW auto");
            String s = this.parent.radioData.replaceFirst("(?is).*?Filters:(.*?)Bandwidths.*", "$1");
            Pattern pattern = Pattern.compile("(?is)[0-9.]+ k?hz");
            Matcher m = pattern.matcher(s);
            while (m.find()) {
                String ss = m.group();
                String[] array = ss.split("\\s+");
                ss = "BW " + ss;
                double mult = array[1].equalsIgnoreCase("hz") ? 1.0 : 1000.0;
                double bw = Double.parseDouble(array[0]) * mult;
                long dv = (long)bw;
                valToKey.put(dv, ss);
            }
            Iterator i$ = valToKey.keySet().iterator();
            while (i$.hasNext()) {
                long dv = (Long)i$.next();
                this.addListItem((String)valToKey.get(dv), dv, "" + dv);
                if (this.parent.comArgs.debug < 1) continue;
                this.parent.p("key to filter : [" + dv + "]");
            }
        }
    }

    protected double getFilterBW() {
        int i = this.getSelectedIndex();
        if (i >= 0 && i < this.reverseUseMap.size()) {
            return Double.parseDouble(this.reverseUseMap.get(i));
        }
        return 0.0;
    }

    protected void setComboBoxIndex(int index) {
        index = Math.max(0, index);
        index = Math.min(index, this.getItemCount() - 1);
        this.setSelectedIndex(index);
    }

    protected void comboPlaceholderData() {
        boolean old_inhibit = this.parent.inhibit;
        this.parent.inhibit = true;
        int index = this.getSelectedIndex();
        index = Math.max(0, index);
        this.removeAllItems();
        for (int i = 1; i < 64; ++i) {
            this.addListItem(String.format("-- n/a %d --", i), i, "" + i);
        }
        this.setComboBoxIndex(index);
        this.parent.inhibit = old_inhibit;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.action(evt);
    }

    private void action(ActionEvent evt) {
        this.writeValue(false);
    }

    @Override
    public void writeValue(boolean force) {
        if (!this.parent.inhibit && !this.localInhibit && this.token != null && this.isEnabled()) {
            if (this.numericMode) {
                this.writeValueNum();
            } else {
                this.writeValueStr();
            }
        }
    }

    protected void writeValueStr() {
        if (this.commOK && !this.parent.inhibit) {
            if (this.needMode) {
                ((RWComboBox)this.parent.sv_modesComboBox).writeValueStr();
            } else {
                if (this.needFilter) {
                    this.strFilter = String.format("%.1f", ((RWComboBox)this.parent.sv_filtersComboBox).getFilterBW());
                }
                int index = this.getSelectedIndex();
                this.strSelection = this.reverseUseMap.get(index);
                if (!(this.strSelection == null || this.strSelection.equals(this.oldStrSelection) && this.strFilter.equals(this.oldFilter))) {
                    String com = String.format("%s %s %s %s", this.prefix.toUpperCase(), this.token, this.strSelection, this.strFilter);
                    this.parent.sendRadioCom(com, 0, true);
                    this.oldStrSelection = this.strSelection;
                    this.oldFilter = this.strFilter;
                }
            }
        }
    }

    protected void writeValueNum() {
        if (this.commOK && !this.parent.inhibit) {
            this.numSelection = this.getConvertedValue();
            if (this.numSelection != this.errorValue) {
                if (this.needMode) {
                    ((RWComboBox)this.parent.sv_modesComboBox).writeValueStr();
                } else if (this.numSelection != this.oldNumSelection) {
                    String com = this.ctcss ? String.format("\\set_ctcss_sql %.0f", this.numSelection) : String.format("%s %s %.2f", this.prefix.toUpperCase(), this.token, this.numSelection);
                    this.parent.sendRadioCom(com, 0, true);
                    this.oldNumSelection = this.numSelection;
                }
            }
        }
    }

    protected double readValueNum() {
        if (this.token != null && this.isEnabled() && this.commOK) {
            String com = this.ctcss ? "\\get_ctcss_sql" : String.format("%s %s", this.prefix.toLowerCase(), this.token);
            this.numSelection = this.errorValue;
            String s = this.parent.sendRadioCom(com, 0, false);
            try {
                this.oldNumSelection = this.numSelection = Double.parseDouble(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.numSelection;
    }

    protected String readValueStr() {
        String s = "";
        if (this.token != null && this.isEnabled() && this.commOK) {
            if (this.needMode) {
                ((RWComboBox)this.parent.sv_modesComboBox).readValueStr();
            } else {
                String com = String.format("%s %s", this.prefix.toLowerCase(), this.token);
                s = this.parent.sendRadioCom(com, 0, false);
            }
        }
        return s;
    }

    protected double ntrp(double xl, double xh, double yl, double yh, double x) {
        return (x - xl) * (yh - yl) / (xh - xl) + yl;
    }

    @Override
    public void readConvertedValue(double x) {
        if (x != 1.0E100) {
            this.numSelection = this.ntrp(this.yValueLow, this.yValueHigh, this.xValueLow, this.xValueHigh, x);
            String sn = String.format("%.0f", this.numSelection);
            this.localInhibit = true;
            try {
                if (this.useMapDouble.containsKey(this.numSelection)) {
                    this.setSelectedIndex(this.useMapDouble.get(this.numSelection));
                } else {
                    Map.Entry<Double, Integer> me = this.useMapDouble.lowerEntry(this.numSelection);
                    if (me == null) {
                        me = this.useMapDouble.higherEntry(this.numSelection);
                    }
                    if (me != null) {
                        this.setSelectedIndex(me.getValue());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            this.localInhibit = false;
        }
    }

    @Override
    public void readConvertedValue() {
        this.localInhibit = true;
        if (this.numericMode) {
            this.readConvertedValue(this.readValueNum());
        } else {
            this.strSelection = this.readValueStr();
            if (this.strSelection != null) {
                if (this.needFilter) {
                    String[] array = this.strSelection.split("(?sm)\\s+");
                    if (array.length >= 2) {
                        this.inhibitSetItem(array[0]);
                        ((RWComboBox)this.parent.sv_filtersComboBox).inhibitSetItem(array[1]);
                    }
                } else {
                    this.inhibitSetItem(this.strSelection);
                }
            }
        }
        this.localInhibit = false;
    }

    protected void inhibitSetItem(String s) {
        try {
            this.localInhibit = true;
            this.setSelectedIndex(this.useMap.get(s));
            this.localInhibit = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void selectiveReadValue(boolean all) {
        if (this.isEnabled()) {
            this.readConvertedValue();
        }
    }

    @Override
    public double getConvertedValue() {
        double v = this.errorValue;
        try {
            int index = this.getSelectedIndex();
            String s = this.reverseUseMap.get(index);
            if (s != null) {
                v = Double.parseDouble(s);
                if (this.numericMode) {
                    v = this.ntrp(this.xValueLow, this.xValueHigh, this.yValueLow, this.yValueHigh, v);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return v;
    }

    @Override
    public void setXLow(double x) {
        this.xValueLow = x;
    }

    @Override
    public void setXHigh(double x) {
        this.xValueHigh = x;
    }

    @Override
    public void setYLow(double y) {
        this.yValueLow = y;
    }

    @Override
    public void setYHigh(double y) {
        this.yValueHigh = y;
        this.numericMode = true;
    }

    private void changeIndex(int v) {
        int len = this.getItemCount();
        if (len > 0) {
            int index = this.getSelectedIndex() + v;
            index = Math.max(index, 0);
            index = Math.min(index, len - 1);
            this.setSelectedIndex(index);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int v = e.getWheelRotation();
        int iv = v < 0 ? -1 : 1;
        this.changeIndex(iv);
    }
}

