/*
 * Decompiled with CFR 0.152.
 */
package jrx;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import jrx.Beep;
import jrx.JRX;
import jrx.MemoryButton;
import jrx.Pair;

public final class SweepScope
extends JPanel
implements MouseMotionListener {
    JRX parent;
    final ArrayList<Pair<Double>> scopeData;
    ArrayList<MemoryButton> scanLimits;
    double xgmin;
    double xgmax;
    double ygmin;
    double ygmax;
    double xmin = 0.0;
    double xmax = 400.0;
    double ymin;
    double ymax;
    double scanStep;
    double old_y = 0.0;
    int scanSpeedMs;
    long startFreq;
    long currentFreq = -1L;
    boolean running = false;
    ArrayList<Pair> userDataList;
    Color dataColor;
    Color gridColor;
    Color bgColor;
    Color zeroColor;
    Color lineColor;
    Timer sweepTimer;
    Timer paintTimer;
    int repaints = 0;
    String toolTip = "";
    String help = "\n(To set a sweep range, click the upper or lower button\nof a pair of memory buttons)";

    public SweepScope(JRX p) {
        this.parent = p;
        this.scopeData = new ArrayList();
        this.bgColor = Color.black;
        this.dataColor = Color.red;
        this.lineColor = new Color(128, 192, 255);
        this.gridColor = new Color(96, 96, 96);
        this.zeroColor = new Color(192, 0, 192);
        this.setBackground(Color.black);
        this.setToolTipText(this.toolTip);
        this.setup();
    }

    protected void setup() {
        this.addMouseMotionListener(this);
        this.setDefaults();
    }

    private void setDefaults() {
        this.ymin = this.parent.squelchLow;
        this.ymax = this.parent.squelchHigh;
        this.repaint();
    }

    public boolean isRunning() {
        return this.running;
    }

    private void setParams() {
        String label = this.isRunning() ? "Stop" : "Start";
        this.parent.scopeStartStopButton.setText(label);
    }

    public void startSweep() {
        this.setDefaults();
        this.parent.scanFunctions.stopScan(false);
        if (!this.isRunning()) {
            this.setupRunSweep();
        } else {
            this.stopSweep(false);
        }
        this.setParams();
    }

    private void setupRunSweep() {
        this.scanLimits = this.parent.getScanButtons(2);
        if (this.scanLimits != null && this.scanLimits.size() >= 2) {
            MemoryButton low = this.scanLimits.get(0);
            MemoryButton high = this.scanLimits.get(1);
            if (low.frequency > high.frequency) {
                MemoryButton temp = low;
                low = high;
                high = temp;
            }
            this.xmin = low.frequency;
            this.currentFreq = this.startFreq = low.frequency;
            this.xmax = high.frequency;
            this.setScanParams();
            this.runSweep();
        } else {
            this.parent.tellUser("Please click the lower of two memory buttons.");
        }
    }

    private void runSweep() {
        this.running = true;
        this.old_y = this.parent.freqStrength(this.currentFreq);
        this.sweepTimer = new Timer();
        this.sweepTimer.scheduleAtFixedRate((TimerTask)new SweepEvents(), 100L, (long)this.scanSpeedMs);
        this.paintTimer = new Timer();
        this.paintTimer.scheduleAtFixedRate((TimerTask)new PaintEvents(false), 100L, 500L);
        this.setParams();
    }

    protected void stopSweep(boolean resetFreq) {
        this.running = false;
        this.currentFreq = -1L;
        if (resetFreq) {
            this.parent.freqStrength(this.startFreq);
        }
        new Timer().schedule((TimerTask)new PaintEvents(true), 100L);
        this.setParams();
    }

    private void setScanParams() {
        this.scopeData.clear();
        if (this.parent.validSetup()) {
            String ss = (String)this.parent.sv_scopeStepComboBox.getSelectedItem();
            this.scanStep = this.parent.scanSteps.get(ss);
            String ts = (String)this.parent.sv_scopeSpeedComboBox.getSelectedItem();
            this.scanSpeedMs = this.parent.timeSteps.get(ts);
        }
    }

    private boolean autoscale2() {
        if (this.scopeData != null) {
            this.ymin = 1.0E30;
            this.ymax = -1.0E30;
            for (Pair<Double> p : this.scopeData) {
                this.ymin = Math.min((Double)p.y, this.ymin);
                this.ymax = Math.max((Double)p.y, this.ymax);
            }
            double range = this.ymax - this.ymin;
            this.ymin -= range * 0.1;
            this.ymax += range * 0.1;
            return true;
        }
        return false;
    }

    protected void autoscale() {
        if (!this.autoscale2()) {
            Beep.beep();
        } else {
            this.repaint();
        }
    }

    void drawScale(Graphics2D cg) {
        double x;
        double y;
        if (this.xmax <= this.xmin || this.ymax <= this.ymin) {
            return;
        }
        BasicStroke dotted = new BasicStroke(2.0f, 0, 2, 1.0f, new float[]{2.0f, 3.0f}, 0.0f);
        Stroke deflt = cg.getStroke();
        cg.setStroke(dotted);
        double scaleFact = 5.0;
        double ystep = Math.abs(this.ymax - this.ymin) / 5.0;
        double s = Math.log(ystep) / Math.log(scaleFact);
        s = Math.floor(s);
        ystep = Math.pow(scaleFact, s);
        cg.setColor(this.gridColor);
        for (y = -ystep; y >= this.ymin; y -= ystep) {
            if (!(y >= this.ymin) || !(y <= this.ymax)) continue;
            this.drawScaledLine(cg, this.xmin, y, this.xmax, y);
        }
        for (y = ystep; y <= this.ymax; y += ystep) {
            if (!(y >= this.ymin) || !(y <= this.ymax)) continue;
            this.drawScaledLine(cg, this.xmin, y, this.xmax, y);
        }
        double xstep = Math.abs(this.xmax - this.xmin) / 5.0;
        s = Math.log(xstep) / Math.log(scaleFact);
        s = Math.floor(s);
        xstep = Math.pow(scaleFact, s);
        cg.setColor(this.gridColor);
        for (x = xstep; x <= this.xmax; x += xstep) {
            if (!(x >= this.xmin) || !(x <= this.xmax)) continue;
            this.drawScaledLine(cg, x, this.ymin, x, this.ymax);
        }
        for (x = -xstep; x >= this.xmin; x -= xstep) {
            if (!(x >= this.xmin) || !(x <= this.xmax)) continue;
            this.drawScaledLine(cg, x, this.ymin, x, this.ymax);
        }
        cg.setStroke(deflt);
        cg.setColor(this.zeroColor);
        this.drawScaledLine(cg, this.xmin, 0.0, this.xmax, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawDataPoints(Graphics2D cg, int dsi) {
        if (this.scopeData != null) {
            cg.setColor(this.dataColor);
            ArrayList<Pair<Double>> arrayList = this.scopeData;
            synchronized (arrayList) {
                for (Pair<Double> pr : this.scopeData) {
                    double x = (Double)pr.x;
                    double y = (Double)pr.y;
                    this.drawScaledPoint(cg, x, y, dsi);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawCurve(Graphics2D cg) {
        if (this.scopeData != null) {
            double ox = 0.0;
            double oy = 0.0;
            boolean first = true;
            cg.setColor(this.lineColor);
            ArrayList<Pair<Double>> arrayList = this.scopeData;
            synchronized (arrayList) {
                for (Pair<Double> p : this.scopeData) {
                    if (!first) {
                        this.drawScaledLine(cg, ox, oy, (Double)p.x, (Double)p.y);
                    }
                    ox = (Double)p.x;
                    oy = (Double)p.y;
                    first = false;
                }
            }
        }
    }

    boolean compScreen() {
        boolean result = false;
        int w = this.getSize().width;
        int h = this.getSize().height;
        if (w > 0 && h > 0) {
            this.xgmin = 1.0;
            this.ygmin = 1.0;
            this.xgmax = w - 2;
            this.ygmax = h - 2;
            result = true;
        }
        return result;
    }

    void drawScaledLine(Graphics g, double ox, double oy, double x, double y) {
        int opx = this.parent.intrp(this.xmin, this.xmax, this.xgmin, this.xgmax, ox);
        int px = this.parent.intrp(this.xmin, this.xmax, this.xgmin, this.xgmax, x);
        int opy = this.parent.intrp(this.ymax, this.ymin, this.ygmin, this.ygmax, oy);
        int py = this.parent.intrp(this.ymax, this.ymin, this.ygmin, this.ygmax, y);
        g.drawLine(opx, opy, px, py);
        if (y < this.ymin || y > this.ymax) {
            this.autoscale2();
        }
    }

    void drawScaledPoint(Graphics g, double x, double y, int dsi) {
        int px = this.parent.intrp(this.xmin, this.xmax, this.xgmin, this.xgmax, x);
        int py = this.parent.intrp(this.ymax, this.ymin, this.ygmin, this.ygmax, y);
        g.fillOval(px, py, dsi, dsi);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        ++this.repaints;
        Graphics2D cg = (Graphics2D)g;
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        cg.addRenderingHints(rh);
        if (this.compScreen()) {
            this.drawScale(cg);
            if (this.scopeData != null) {
                this.drawCurve(cg);
                if (this.parent.sv_scopeDotsCheckBox.isSelected()) {
                    this.drawDataPoints(cg, 2);
                }
            }
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.toolTip;
    }

    private String convertx(double x) {
        int i;
        String[] scales = new String[]{"Hz", "KHz", "MHz", "GHz"};
        double sc = 1.0;
        for (i = 0; x > sc * 1000.0 && i < scales.length - 1; ++i) {
            sc *= 1000.0;
        }
        return String.format("%.4f %s", x / sc, scales[i]);
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        int w = this.getWidth();
        int h = this.getHeight();
        double mx = me.getPoint().getX();
        double my = me.getPoint().getY();
        double qx = this.parent.ntrp(0.0, w, this.xmin, this.xmax, mx);
        double qy = this.parent.ntrp(0.0, h, this.ymin, this.ymax, (double)h - my);
        String sx = this.convertx(qx);
        this.toolTip = String.format("x = %s, y = %.4f", sx, qy);
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.mouseMoved(me);
    }

    protected void saveData() {
        if (this.scopeData == null) {
            Beep.beep();
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("Frequency,Amplitude\n");
            for (Pair<Double> p : this.scopeData) {
                sb.append(String.format("%.0f,%.2f\n", p.x, p.y));
            }
            this.parent.writeToClipboard(sb.toString());
        }
    }

    class PaintEvents
    extends TimerTask {
        boolean force;

        public PaintEvents(boolean f) {
            this.force = f;
        }

        @Override
        public void run() {
            if (SweepScope.this.running || this.force) {
                SweepScope.this.repaint();
            } else if (SweepScope.this.paintTimer != null) {
                SweepScope.this.paintTimer.cancel();
            }
        }
    }

    class SweepEvents
    extends TimerTask {
        SweepEvents() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (SweepScope.this.running) {
                double y = SweepScope.this.parent.freqStrength(SweepScope.this.currentFreq);
                if (y == -1.0E30) {
                    y = SweepScope.this.old_y;
                }
                SweepScope.this.old_y = y;
                if (SweepScope.this.currentFreq >= 0L) {
                    ArrayList<Pair<Double>> arrayList = SweepScope.this.scopeData;
                    synchronized (arrayList) {
                        SweepScope.this.scopeData.add(new Pair<Double>(Double.valueOf(SweepScope.this.currentFreq), y));
                    }
                    SweepScope.this.currentFreq = (long)((double)SweepScope.this.currentFreq + SweepScope.this.scanStep);
                    if ((double)SweepScope.this.currentFreq > SweepScope.this.xmax) {
                        SweepScope.this.stopSweep(false);
                    }
                }
            } else if (SweepScope.this.sweepTimer != null) {
                SweepScope.this.sweepTimer.cancel();
            }
        }
    }
}

