/*
 * Decompiled with CFR 0.152.
 */
package jsqliteclient;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JTextField;
import jsqliteclient.Beep;
import jsqliteclient.Configurable;
import jsqliteclient.Executable;

public final class HistoryEngine
implements Configurable {
    Executable exec;
    JTextField entryField;
    ArrayList<String> history;
    int historyIndex = 0;
    boolean interactive;
    int maxHistorySize = 32;

    public HistoryEngine(Executable e, JTextField ef, boolean interact) {
        this.exec = e;
        this.entryField = ef;
        this.interactive = interact;
        this.history = new ArrayList();
        ef.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                HistoryEngine.this.testKey(evt);
            }
        });
    }

    private void testKey(KeyEvent evt) {
        switch (evt.getKeyCode()) {
            case 10: {
                this.processEntry();
                break;
            }
            case 40: {
                this.fetchHistory(1);
                break;
            }
            case 38: {
                this.fetchHistory(-1);
            }
        }
    }

    private void processEntry() {
        String text = this.entryField.getText().trim();
        this.insertIntoHistory(text);
        if (this.interactive) {
            this.insertIntoHistory("");
            this.entryField.setText("");
        }
        this.exec.execute(text);
    }

    protected JTextField getControl() {
        return this.entryField;
    }

    protected void fetchHistory(int n) {
        String pending;
        int top = this.history.size();
        if (top == 0) {
            Beep.beep();
            return;
        }
        if (this.historyIndex == top - 1 && (pending = this.entryField.getText().trim()).length() > 0) {
            this.insertIntoHistory(pending);
        }
        top = this.history.size();
        this.historyIndex += n;
        int oth = this.historyIndex;
        this.historyIndex = Math.max(0, this.historyIndex);
        this.historyIndex = Math.min(top - 1, this.historyIndex);
        if (oth != this.historyIndex) {
            Beep.beep();
        }
        String s = this.history.get(this.historyIndex);
        this.entryField.setText(s);
    }

    protected void insertIntoHistory(String com) {
        if (com != null) {
            while (this.history.contains(com)) {
                this.history.remove(com);
            }
            this.history.add(com);
            int sz = this.history.size();
            if (sz >= this.maxHistorySize) {
                this.history = new ArrayList<String>(this.history.subList(sz - this.maxHistorySize, sz));
            }
            this.historyIndex = this.history.size() - 1;
        }
    }

    protected void clearHistory() {
        this.history = new ArrayList();
    }

    @Override
    public void fromString(String shist) {
        String[] array = shist.split("\t");
        this.history = new ArrayList<String>(Arrays.asList(array));
        this.history.add("");
        this.historyIndex = this.history.size() - 1;
    }

    @Override
    public String toString() {
        String result = "";
        Iterator<String> iter = this.history.iterator();
        if (iter.hasNext()) {
            StringBuilder sb = new StringBuilder(iter.next());
            while (iter.hasNext()) {
                sb.append("\t");
                sb.append(iter.next());
            }
            result = sb.toString();
        }
        return result;
    }
}

