/*
 * Decompiled with CFR 0.152.
 */
package jsqliteclient;

import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Scanner;
import jsqliteclient.Executable;
import jsqliteclient.HistoryEngine;
import jsqliteclient.JSQLiteClient;
import jsqliteclient.QueryProcessor;

public final class TerminalFunctions
implements Executable {
    JSQLiteClient parent;
    Connection conn = null;
    ArrayList<String> sqlColNames;
    int[] columnWidths;
    ArrayList<ArrayList<Object>> data;
    String prompt = "JDBClient> ";
    String currentCom;

    public TerminalFunctions(JSQLiteClient p) {
        this.parent = p;
        this.setState();
        this.parent.terminalTextDisplay.setEditable(false);
        this.parent.sv_termEngine = new HistoryEngine(this, this.parent.terminalCommandTextField, true);
        this.connect(false);
    }

    protected void connect(boolean connect) {
        long startTime = System.currentTimeMillis();
        String error = null;
        try {
            if (connect) {
                String dbUrl = this.parent.makeDBUrl();
                QueryProcessor qp = new QueryProcessor(this.parent, null, true);
                this.conn = qp.configureConection(dbUrl);
                assert (this.conn != null);
                this.clear();
                this.addText(this.prompt);
            } else {
                if (this.conn != null) {
                    this.conn.close();
                }
                this.conn = null;
                this.clear();
                this.addText("(Not connected)\n");
            }
        }
        catch (Exception e) {
            if (this.parent.debug) {
                e.printStackTrace(System.out);
            }
            this.logErrors(e);
            error = e.getMessage();
        }
        this.setState();
        long endTime = System.currentTimeMillis();
        this.parent.logEventAction("T: connect", startTime, endTime, error);
    }

    protected void wrapControl() {
        this.parent.terminalTextDisplay.setLineWrap(this.parent.sv_termWrapCheckBox.isSelected());
    }

    protected void logErrors(Exception err) {
        this.addText(String.format("Error: %s\n", err.getMessage()));
    }

    protected void addText(String s) {
        this.parent.terminalTextDisplay.append(s);
        this.parent.terminalTextDisplay.setCaretPosition(this.parent.terminalTextDisplay.getDocument().getLength());
    }

    protected void setFont() {
        this.parent.terminalTextDisplay.setFont(this.parent.baseFont);
        this.parent.terminalCommandTextField.setFont(this.parent.baseFont);
    }

    protected void getResults(ResultSet rs) {
        this.data = new ArrayList();
        int internalPad = 2;
        this.sqlColNames = new ArrayList();
        try {
            ResultSetMetaData md = rs.getMetaData();
            int cols = md.getColumnCount();
            this.columnWidths = new int[cols];
            for (int i = 0; i < cols; ++i) {
                String cl = md.getColumnLabel(i + 1);
                this.sqlColNames.add(cl);
                this.columnWidths[i] = cl.length() + internalPad;
            }
            while (rs.next()) {
                ArrayList<Object> row = new ArrayList<Object>();
                int i = 0;
                for (String obj : this.sqlColNames) {
                    String key = obj.toString().trim();
                    Object out = null;
                    try {
                        out = rs.getObject(key);
                    }
                    catch (Exception e) {
                        if (this.parent.debug) {
                            e.printStackTrace(System.out);
                        }
                        this.logErrors(e);
                    }
                    out = out == null ? "NULL" : out;
                    row.add(out);
                    this.columnWidths[i] = Math.max(this.columnWidths[i], out.toString().length() + internalPad);
                    ++i;
                }
                this.data.add(row);
            }
        }
        catch (Exception e) {
            if (this.parent.debug) {
                e.printStackTrace(System.out);
            }
            this.logErrors(e);
        }
    }

    protected String padString(String s, String pad, int len, int t) {
        s = String.format("%s%s%s", pad, s, pad);
        StringBuilder sb = new StringBuilder();
        if (t == 0) {
            sb.append(s);
        }
        int alen = len - s.length();
        int blen = 0;
        if (t == 1) {
            alen = (len - s.length()) / 2;
            blen = len - (alen + s.length());
        }
        for (int i = 0; i < alen; ++i) {
            sb.append(pad);
        }
        if (t == 1) {
            sb.append(s);
            while (blen > 0) {
                sb.append(pad);
                --blen;
            }
        }
        if (t == 2) {
            sb.append(s);
        }
        return sb.toString();
    }

    protected String tableLine(int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append("-");
        }
        sb.append("+");
        return sb.toString();
    }

    protected void showResultSet(ResultSet rs, long st, long et, boolean display) {
        if (rs != null) {
            this.getResults(rs);
            StringBuilder sb = new StringBuilder();
            int rows = this.data.size();
            if (rows >= 0) {
                String pad = " ";
                StringBuilder sh = new StringBuilder("|");
                StringBuilder sl = new StringBuilder("+");
                int i = 0;
                for (String string : this.sqlColNames) {
                    sl.append(this.tableLine(this.columnWidths[i]));
                    sh.append(this.padString(string, pad, this.columnWidths[i], 1));
                    sh.append("|");
                    ++i;
                }
                sl.append("\n");
                sb = new StringBuilder(sl);
                sb.append((CharSequence)sh);
                sb.append("\n");
                sb.append((CharSequence)sl);
                for (ArrayList arrayList : this.data) {
                    sb.append("|");
                    i = 0;
                    for (Object obj : arrayList) {
                        int mode = obj instanceof String ? 0 : 2;
                        sb.append(this.padString(obj.toString(), pad, this.columnWidths[i], mode));
                        sb.append("|");
                        ++i;
                    }
                    sb.append("\n");
                }
                sb.append((CharSequence)sl);
            }
            long jt = System.currentTimeMillis();
            long md = et - st;
            long jd = jt - et;
            long tt = jt - st;
            sb.append(String.format("%s rows in set (%.2f total, SQLite %.2f, Java %.2f sec)\n", rows, this.getDoubleTime(tt), this.getDoubleTime(md), this.getDoubleTime(jd)));
            this.addText(sb.toString());
        }
    }

    protected double getDoubleTime(long v) {
        return (double)v / 1000.0;
    }

    protected void clear() {
        this.parent.terminalTextDisplay.setText("");
        this.setState();
    }

    protected void copyToClipboard() {
        this.parent.writeToClipboard(this.parent.terminalTextDisplay.getText());
    }

    public String readSQLDumpFile(String path) {
        long startTime = System.currentTimeMillis();
        String error = null;
        String result = null;
        try {
            if (path.matches(".*(http|ftp):.*")) {
                URL url = new URL(path);
                result = new Scanner(url.openStream()).useDelimiter("\\Z").next();
            } else {
                result = new Scanner(new File(path)).useDelimiter("\\Z").next();
            }
        }
        catch (Exception e) {
            if (this.parent.debug) {
                e.printStackTrace(System.out);
            }
            error = e.getMessage();
            this.logErrors(e);
        }
        long endTime = System.currentTimeMillis();
        this.parent.logEventAction(String.format("T: read file/URL %s", path), startTime, endTime, error);
        return result;
    }

    protected void processFile(String path) {
        String fdata = this.readSQLDumpFile(path);
        if (fdata != null) {
            String[] array = fdata.split("\n");
            StringBuilder com = new StringBuilder();
            for (String item : array) {
                this.addText(".");
                item = item.trim();
                if (item.length() <= 0 || item.matches("--.*")) continue;
                com.append(item).append(" ");
                if (!item.matches(".*;$")) continue;
                this.executeOneCom(com.toString(), false);
                com = new StringBuilder();
            }
            this.addText("\n");
        }
    }

    @Override
    public void execute(String text) {
        try {
            String[] array;
            for (String com : array = text.split(";")) {
                if ((com = com.trim()).matches("(?i).*source\\s.*")) {
                    this.addText(com + "\n");
                    String path = com.replaceFirst("(?i).*source\\s+(.*)$", "$1");
                    this.processFile(path);
                    this.addText(this.prompt);
                    continue;
                }
                this.executeOneCom(com, true);
            }
        }
        catch (Exception e) {
            if (this.parent.debug) {
                e.printStackTrace(System.out);
            }
            this.logErrors(e);
        }
    }

    protected void executeOneCom(String com, boolean display) {
        long startTime = System.currentTimeMillis();
        if (com != null && com.length() > 0) {
            String error;
            block6: {
                error = null;
                try {
                    this.currentCom = com;
                    if (display) {
                        this.addText(" " + com + "\n");
                    }
                    long st = System.currentTimeMillis();
                    Statement stmt = this.conn.createStatement();
                    String escCom = this.parent.escapeQueryArg(com);
                    stmt.execute(escCom);
                    long et = System.currentTimeMillis();
                    ResultSet rs = stmt.getResultSet();
                    this.showResultSet(rs, st, et, display);
                    if (display) {
                        this.addText(this.prompt);
                    }
                    stmt.close();
                }
                catch (Exception e) {
                    if (this.parent.debug) {
                        e.printStackTrace(System.out);
                    }
                    error = e.getMessage();
                    this.logErrors(e);
                    if (!display) break block6;
                    this.addText(this.prompt);
                }
            }
            long endTime = System.currentTimeMillis();
            this.parent.logEventAction(String.format("T: %s", this.currentCom), startTime, endTime, error);
        }
    }

    protected void connectDisconnect() {
        this.connect(this.conn == null);
        this.setFont();
    }

    protected void setState() {
        this.parent.connectButton.setText(this.conn == null ? "Connect" : "Disconnect");
        this.parent.terminalCommandTextField.setEnabled(this.conn != null);
        this.parent.terminalCommandTextField.grabFocus();
        this.wrapControl();
    }

    public void p(String s) {
        System.out.println(s);
    }
}

