/*
 * Decompiled with CFR 0.152.
 */
package jsqliteclient;

import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jsqliteclient.Configurable;
import jsqliteclient.JSQLiteClient;
import jsqliteclient.MyJTextField;
import jsqliteclient.QueryProcessor;

public final class QueryControlRow
implements Configurable {
    JSQLiteClient parent;
    QueryProcessor qProcessor;
    ArrayList<JComponent> row;
    String fieldName;
    int y;
    JLabel fieldLabel;
    JRadioButton leftAndOp;
    JRadioButton rightAndOp;
    ButtonGroup leftButtonGroup;
    ButtonGroup rightButtonGroup;
    JRadioButton leftOrOp;
    JRadioButton rightOrOp;
    MyJTextField leftEntryField;
    MyJTextField rightEntryField;
    JCheckBox includeCheckBox;

    public QueryControlRow(JSQLiteClient p, String fn, int y, QueryProcessor qr) {
        this.parent = p;
        this.qProcessor = qr;
        this.y = y;
        this.fieldName = fn;
        this.row = new ArrayList();
        this.setupRow(p.queryLayoutPanel);
    }

    private void setupRow(JPanel panel) {
        Insets insets = new Insets(-1, 2, -1, 2);
        this.fieldLabel = new JLabel("<html><b>" + this.fieldName + ":</b></html>");
        this.row.add(this.fieldLabel);
        this.leftAndOp = new JRadioButton("And");
        this.row.add(this.leftAndOp);
        this.leftOrOp = new JRadioButton("Or");
        this.row.add(this.leftOrOp);
        this.leftEntryField = new MyJTextField(this.parent, this.qProcessor);
        this.row.add(this.leftEntryField);
        this.rightAndOp = new JRadioButton("And");
        this.row.add(this.rightAndOp);
        this.rightOrOp = new JRadioButton("Or");
        this.row.add(this.rightOrOp);
        this.rightEntryField = new MyJTextField(this.parent, this.qProcessor);
        this.row.add(this.rightEntryField);
        this.includeCheckBox = new JCheckBox("Inc");
        this.row.add(this.includeCheckBox);
        int x = 0;
        for (JComponent comp : this.row) {
            comp.setFont(this.parent.baseFont);
            boolean isTextField = comp instanceof JTextField;
            float weight = isTextField ? 1.0f : 0.0f;
            panel.add((Component)comp, this.parent.createConstraints(x, this.y, 1, weight, insets));
            if (isTextField || comp instanceof JCheckBox) {
                comp.setToolTipText(String.format(this.parent.queryTableToolTips[x], this.fieldName));
            } else {
                comp.setToolTipText(this.parent.queryTableToolTips[x]);
            }
            ++x;
        }
        this.row.remove(0);
        this.leftButtonGroup = new ButtonGroup();
        this.leftButtonGroup.add(this.leftAndOp);
        this.leftButtonGroup.add(this.leftOrOp);
        this.rightButtonGroup = new ButtonGroup();
        this.rightButtonGroup.add(this.rightAndOp);
        this.rightButtonGroup.add(this.rightOrOp);
        this.leftAndOp.setSelected(true);
        this.rightAndOp.setSelected(true);
        this.includeCheckBox.setSelected(true);
    }

    protected boolean getInclude() {
        return this.includeCheckBox.isSelected();
    }

    protected String getFieldName() {
        return this.fieldName;
    }

    private String logicOp(JRadioButton andButton) {
        return andButton.isSelected() ? "AND" : "OR";
    }

    private String textOp(JTextField tf) {
        String result = "";
        String s = tf.getText().trim();
        if (s.length() > 0) {
            StringBuilder arg = new StringBuilder();
            arg.append(String.format("`%s` ", this.fieldName));
            if (!s.matches("(?i).*(regexp|>|=|<|like|between).*")) {
                arg.append("REGEXP ");
                if (!s.matches("^\".*\"$")) {
                    s = this.escapeQuote(s);
                }
            }
            arg.append(s);
            result = arg.toString();
        }
        return result;
    }

    String escapeQuote(String s) {
        return String.format("\"%s\"", s.replaceAll("\"", "\"\""));
    }

    protected ArrayList<String> buildQuery(ArrayList<String> arg) {
        boolean enclose;
        String logica = this.logicOp(this.leftAndOp);
        String logicb = this.logicOp(this.rightAndOp);
        String arga = this.textOp(this.leftEntryField);
        String argb = this.textOp(this.rightEntryField);
        int argalen = arga.length();
        int argblen = argb.length();
        if (argalen == 0 && argblen == 0) {
            return arg;
        }
        boolean bl = enclose = argalen > 0 && argblen > 0;
        if (enclose) {
            if (arg.size() > 0) {
                arg.add(logica);
            }
            arg.add("(");
        }
        if (argalen > 0) {
            if (!enclose && arg.size() > 0) {
                arg.add(logica);
            }
            arg.add(arga);
        }
        if (argblen > 0) {
            if (arg.size() > 0) {
                arg.add(logicb);
            }
            arg.add(argb);
        }
        if (enclose) {
            arg.add(")");
        }
        return arg;
    }

    @Override
    public String toString() {
        ArrayList<String> out = new ArrayList<String>();
        for (Component component : this.row) {
            if (component instanceof JLabel) {
                out.add(((JLabel)component).getText());
                continue;
            }
            if (component instanceof JTextField) {
                out.add(((JTextField)component).getText());
                continue;
            }
            if (component instanceof JCheckBox) {
                out.add(((JCheckBox)component).isSelected() ? "1" : "0");
                continue;
            }
            if (!(component instanceof JRadioButton)) continue;
            out.add(((JRadioButton)component).isSelected() ? "1" : "0");
        }
        return String.join((CharSequence)"\t", out);
    }

    @Override
    public void fromString(String data) {
        String[] values = data.split("\t", -1);
        int i = 0;
        for (Component component : this.row) {
            if (component instanceof JLabel) {
                ((JLabel)component).setText(values[i]);
            } else if (component instanceof JTextField) {
                ((JTextField)component).setText(values[i]);
            } else if (component instanceof JCheckBox) {
                ((JCheckBox)component).setSelected(values[i].equals("1"));
            } else if (component instanceof JRadioButton) {
                ((JRadioButton)component).setSelected(values[i].equals("1"));
            }
            ++i;
        }
    }

    private void p(String s) {
        System.out.println(s);
    }
}

