; Name of our application

!define APPNAME "JSQLiteClient"

Name "${APPNAME}"

Icon "${APPNAME}.ico"

UninstallIcon "${APPNAME}.ico"

!include "MUI2.nsh"

!define MUI_ICON "${APPNAME}.ico"
!define MUI_UNICON "${APPNAME}.ico"

!define MUI_PRODUCT "${APPNAME}"

!define MUI_BRANDINGTEXT "${APPNAME}"

!insertmacro MUI_LANGUAGE "English"

; The file to write
OutFile "${APPNAME}.exe"

; Set the default Installation Directory
InstallDir "$PROGRAMFILES\${APPNAME}"

; Set the text which prompts the user to enter the installation directory
DirText "Please choose a directory for this application:"

; ----------------------------------------------------------------------------------
; *************************** SECTION FOR INSTALLING *******************************
; ----------------------------------------------------------------------------------

Section "Install"

SetShellVarContext all

; Set output path to the installation directory. Also sets the working
; directory for shortcuts

SetOutPath "$INSTDIR"
File "${APPNAME}.jar"
File "${APPNAME}.ico"
File "${APPNAME}.bat"

WriteUninstaller $INSTDIR\Uninstall.exe

; *** CREATE SHORT CUTS

CreateDirectory "$SMPROGRAMS\${APPNAME}"

SetOutPath "$INSTDIR"

CreateShortCut "$SMPROGRAMS\${APPNAME}\Uninstall ${APPNAME}.lnk" "$INSTDIR\Uninstall.exe" 

; This is a way to get around a Windows limitation that prevents a shortcut icon from appearing
; It should be reviewed as time passes -- it may not be required forever

; 1. Put a copy of the app icon in AppData

SetOutPath "$APPDATA\${APPNAME}"
File "${APPNAME}.ico"

; 2. Create shortcuts using this icon location

CreateShortCut "$SMPROGRAMS\${APPNAME}\${APPNAME}.lnk" "$INSTDIR\${APPNAME}.bat" "" "$APPDATA\${APPNAME}\${APPNAME}.ico" 0

; optional desktop shortcut

CreateShortCut "$DESKTOP\${APPNAME}.lnk" "$INSTDIR\${APPNAME}.bat" "" "$APPDATA\${APPNAME}\${APPNAME}.ico" 0

; *** END CREATING SHORTCUTS

; *** CREATE REGISTRY KEYS FOR ADD/REMOVE PROGRAMS IN CONTROL PANEL

WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}" "DisplayName"\
"${APPNAME} (remove only)"

WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}" "UninstallString" \
"$INSTDIR\Uninstall.exe"

; *** END CREATING REGISTRY KEYS

MessageBox MB_OK "Installation was successful.$\r$\n\
$\r$\n\
NOTES:$\r$\n\
$\r$\n\
This Java program must have a Java runtime engine to run. An appropriate, free engine is available at http://java.com. The Java engine available on some older Windows installations may not be the right version for this program.$\r$\n\
$\r$\n\
Installing a new version of ${APPNAME} will not lose your user-defined option settings. These files are located in the user's directory (under a directory named $\".${APPNAME}$\"), not in the program directory. This allows more than one person per system to use a copy of ${APPNAME}, but with individual choices and preferences."

StrCmp ${APPNAME} "Arachnophilia" 0 notreally
  WriteRegStr HKCR "${APPNAME}" "" "${APPNAME}"
  WriteRegStr HKCR "${APPNAME}\shell\open\command" "" "$\"$INSTDIR\${APPNAME}.jar$\" $\"%1$\""
  WriteRegStr HKCR "${APPNAME}\shell\edit\command" "" "$\"$INSTDIR\${APPNAME}.jar$\" $\"%1$\""
  WriteRegStr HKCR "${APPNAME}\DefaultIcon" "" "$APPDATA\${APPNAME}\${APPNAME}.ico"
  WriteRegStr HKCR ".html" "" "${APPNAME}"
  WriteRegStr HKCR ".htm" "" "${APPNAME}"
notreally:

SectionEnd

; ----------------------------------------------------------------------------------
; ************************** SECTION FOR UNINSTALLING ******************************
; ----------------------------------------------------------------------------------

# Uninstaller
 
function un.onInit
	SetShellVarContext all
	#Verify the uninstaller - last chance to back out
	MessageBox MB_OKCANCEL "Permanantly remove ${APPNAME}?" IDOK next
		Abort
	next:
functionEnd

Section "Uninstall"

SetShellVarContext all

; remove all the startmenu links
Delete "$DESKTOP\${APPNAME}.lnk"
Delete "$SMPROGRAMS\${APPNAME}\*.*"
RMDir "$SMPROGRAMS\${APPNAME}"

; delete registry keys
DeleteRegKey HKEY_LOCAL_MACHINE "SOFTWARE\${APPNAME}"
DeleteRegKey HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\${APPNAME}"

; remove all the files and folders
Delete "$INSTDIR\*.*"
RMDir "$INSTDIR"

SectionEnd
