// ***************************************************************************
// *   Copyright (C) 2017 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************
package jsqliteclient;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;

/**
 *
 * @author lutusp
 */
final public class MyJTextArea extends javax.swing.JTextArea implements FocusListener {

    JSQLiteClient parent;
    static final long serialVersionUID = 2612;
    EditFunctions eFunct;
    boolean changed = false;
    String fieldName = null;

    public MyJTextArea(JSQLiteClient p, EditFunctions ef, String k) {
        super();
        parent = p;
        eFunct = ef;
        fieldName = k;
        setup();
    }

    private void setup() {
        setFont(parent.baseFont);
        addKeyListener(new java.awt.event.KeyAdapter() {
            @Override
            public void keyReleased(java.awt.event.KeyEvent evt) {
                testKey(evt);
            }
        });
        addFocusListener(this);
    }

    private void testKey(java.awt.event.KeyEvent evt) {
        // only set "changed" on character keys
        if (!evt.isActionKey() && evt.getKeyChar() != KeyEvent.CHAR_UNDEFINED) {
            changed = true;
            eFunct.setChanged();
            setBackground(parent.changedBColor);
        }
        // actions for shift + key
        if ((evt.getModifiers() & KeyEvent.SHIFT_MASK) != 0) {
            switch (evt.getKeyCode()) {
                case KeyEvent.VK_ENTER:
                    eFunct.commitEdit();
                    break;
                case KeyEvent.VK_UP:
                    eFunct.vtab(this, -1);
                    break;
                case KeyEvent.VK_DOWN:
                    eFunct.vtab(this, 1);
                    break;
            }
        }
    }

    protected void clearChanged() {
        changed = false;
        setForeground(Color.black);
    }

    @Override
    public void focusLost(FocusEvent evt) {
    }

    // this allows the control to retgain focus after
    // showing a dialog
    @Override
    public void focusGained(FocusEvent evt) {
        eFunct.saveFocus(fieldName);

    }
}
