// ***************************************************************************
// *   Copyright (C) 2017 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************
package jsqliteclient;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JTable;

/**
 *
 * @author lutusp
 */
final public class MyJTable extends JTable implements MouseListener, MouseMotionListener {

    JSQLiteClient parent;
    int hoverRow = -1;
    static final long serialVersionUID = 10542;

    @SuppressWarnings("LeakingThisInConstructor")
    public MyJTable(JSQLiteClient p) {
        parent = p;
        addMouseListener(this);
        addMouseMotionListener(this);
    }
    
    @Override
    public String getToolTipText(MouseEvent evt) {
        Point p = evt.getPoint();
        int row = rowAtPoint(p);
        return String.format("Click to edit record %d" , row+1);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int vColIndex) {
        return false;
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        Point p = evt.getPoint();
        hoverRow = this.rowAtPoint(p);
        repaint();
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        hoverRow = -1;
        repaint();
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        Point p = evt.getPoint();
        int row = this.rowAtPoint(p);
        parent.editFunctions.activateEdit(row);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

}
