/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package jsqliteclient;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

/**
 *
 * @author lutusp
 */
public class MyListCellRenderer extends DefaultListCellRenderer {

    JSQLiteClient parent;
    ListCellRenderer lcr;
    static final long serialVersionUID = 117648;

    public MyListCellRenderer(JSQLiteClient p, ListCellRenderer lcr) {
        parent = p;
        this.lcr = lcr;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value,
            int index, boolean isSelected, boolean cellHasFocus) {

        JLabel jl = (JLabel) lcr.getListCellRendererComponent(list, value,
                index, isSelected, cellHasFocus);
        String sv = (String) value;
        if (sv != null) {
            // show short label
            String ss = sv.replaceFirst(".*[\\\\/](.*)", "$1");
            jl.setText(ss);
            // show long tooltip
            jl.setToolTipText(sv);
        }
        return jl;
    }

}
