// ***************************************************************************
// *   Copyright (C) 2017 by Paul Lutus                                      *
// *   lutusp@arachnoid.com                                                  *
// *                                                                         *
// *   This program is free software; you can redistribute it and/or modify  *
// *   it under the terms of the GNU General Public License as published by  *
// *   the Free Software Foundation; either version 2 of the License, or     *
// *   (at your option) any later version.                                   *
// *                                                                         *
// *   This program is distributed in the hope that it will be useful,       *
// *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
// *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
// *   GNU General Public License for more details.                          *
// *                                                                         *
// *   You should have received a copy of the GNU General Public License     *
// *   along with this program; if not, write to the                         *
// *   Free Software Foundation, Inc.,                                       *
// *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
// ***************************************************************************

package jsqliteclient;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.sqlite.Function;

/**
 *
 * @author lutusp
 */
public class SQLRegex {
    JSQLiteClient parent;
    public SQLRegex(JSQLiteClient p) {
        parent = p;
    }
    
    // Create regexp() function to make the REGEXP operator available
    public void defineRegex(Connection conn) {
        try {
            Function.create(conn, "REGEXP", new Function() {
                protected void xFunc() throws SQLException {
                    String expression = value_text(0);
                    String value = value_text(1);
                    if (value == null)
                        value = "";
                    // default to case insensitivity
                    Pattern pattern=Pattern.compile(String.format("(?i)%s",expression));
                    result(pattern.matcher(value).find() ? 1 : 0);
                    }
            });
        } catch (SQLException ex) {
            if (parent.debug) {
                    ex.printStackTrace(System.out);
                }
        }
    }
}
