/*
 * Decompiled with CFR 0.152.
 */
package jsiggen;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import jsiggen.ControlInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComboBoxController
implements ControlInterface {
    JComboBox box;
    String value;
    int ivalue = 0;
    int index = 0;

    public ComboBoxController(JComboBox b, List<String> data, String sel) {
        this.box = b;
        this.box.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent evt) {
                ComboBoxController.this.mouse_wheel_event(evt);
            }
        });
        this.box.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ComboBoxController.this.item_state_changed(evt);
            }
        });
        this.populate_combobox(data, sel);
    }

    public void populate_combobox(List<String> data, String sel) {
        this.box.removeAllItems();
        Iterator<String> i = data.iterator();
        while (i.hasNext()) {
            this.box.addItem(i.next());
        }
        this.set_value(sel);
    }

    private void mouse_wheel_event(MouseWheelEvent evt) {
        if (this.box.isEnabled()) {
            double n = evt.getWheelRotation() > 0 ? 1.0 : -1.0;
            n = evt.isShiftDown() ? n * 10.0 : n;
            n = evt.isControlDown() ? n * 10.0 : n;
            n = evt.isAltDown() ? n * 10.0 : n;
            int v = this.box.getSelectedIndex();
            v = (int)((double)v + n);
            v = this.check_range(v);
            this.box.setSelectedIndex(v);
        }
    }

    private int check_range(int v) {
        int top = this.box.getItemCount();
        v = Math.min(top - 1, v);
        v = Math.max(0, v);
        return v;
    }

    private void item_state_changed(ItemEvent evt) {
        this.index = this.box.getSelectedIndex();
        this.value = (String)this.box.getSelectedItem();
        try {
            this.ivalue = Integer.parseInt(this.value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String get_value() {
        return this.value;
    }

    public int get_ivalue() {
        return this.ivalue;
    }

    public int get_index() {
        return this.index;
    }

    @Override
    public void set_value(String s) {
        this.box.setSelectedItem(s);
        this.value = s;
    }

    @Override
    public String toString() {
        return this.value;
    }
}

