/***************************************************************************
 *   Copyright (C) 2011 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * NewJSigGen.java
 *
 * Created on Feb 25, 2011, 1:31:49 AM
 */
package jsiggen;

//import javax.swing.*;
import java.util.*;
import javax.sound.sampled.*;
import java.util.Timer;
import java.util.TimerTask;

/**
 *
 * @author lutusp
 */
public class JSigGenPanel extends javax.swing.JPanel {

    /** Creates new form NewJSigGen */
    //public NewJSigGen() {
    //    initComponents();
    //}
    JSigGen parent = null;
    String user_dir = null, file_sep, ini_path = null;
    ConfigManager config_mgr;
    ToggleButtonController controller_enabled, left_channel_enabled, right_channel_enabled, modulation_enabled, noise_enabled, signal_enabled;
    ComboBoxController modulation_waveform, data_rate, output_channel, signal_waveform, am_fm_mode;
    TextFieldController frequency, modulation_frequency, modulation_level, signal_level, noise_level;
    Line.Info sourceLineInfo;
    java.util.ArrayList<Mixer> source_mixers;
    SignalGenerator generator = null;
    Timer periodic_timer;
    int timer_period_ms = 500;

    /** Creates new form JSigGen */
    public JSigGenPanel(String[] args) {
        setup(args);
    }

    public JSigGenPanel(JSigGen p, String[] args) {
        parent = p;
        setup(args);
    }

    private void setup(String[] args) {
        List<String> data_rates = Arrays.asList(
                "192000", "96000", "48000", "32000", "24000", "16000", "12000", "8000", "6000");
        String default_rate = "48000";
        double freqStep = 1;
        initComponents();
        file_sep = System.getProperty("file.separator");
        if (parent != null) {
            user_dir = System.getProperty("user.home");
            ini_path = user_dir + file_sep + "." + parent.app_name + ".ini";
        }
        if (args.length > 0) {
            try {
                String ss = args[0].replaceFirst("--fstep=(.*)","$1");
                freqStep = Double.parseDouble(ss);
            } catch (Exception e) {
            }
        }
        controller_enabled = new ToggleButtonController(controller_enable_checkbutton, true);
        left_channel_enabled = new ToggleButtonController(left_checkbox, true);
        right_channel_enabled = new ToggleButtonController(right_checkbox, true);
        modulation_enabled = new ToggleButtonController(modulation_enable_checkbox, false);
        noise_enabled = new ToggleButtonController(noise_enable_checkbox, false);
        signal_enabled = new ToggleButtonController(signal_enable_checkbox, true);
        List<String> waveforms = Arrays.asList("Sine", "Triangle", "Square", "Sawtooth");
        modulation_waveform = new ComboBoxController(modulation_waveform_combobox, waveforms, "Sine");
        signal_waveform = new ComboBoxController(signal_waveform_combobox, waveforms, "Sine");
        data_rate = new ComboBoxController(data_rate_combobox, data_rates, default_rate);
        List<String> modes = Arrays.asList("AM", "FM");
        am_fm_mode = new ComboBoxController(am_fm_combobox, modes, "AM");
        find_source_mixers();
        List<String> data = new ArrayList<String>();
        int len = source_mixers.size();
        for (int i = len; i > 0; i--) {
            data.add("" + i);
        }
        output_channel = new ComboBoxController(output_channel_combobox, data, "1");
        frequency = new TextFieldController(frequency_textfield, freqStep, "440");
        modulation_frequency = new TextFieldController(modulation_frequency_textfield, 1.0, "1");
        modulation_level = new TextFieldController(modulation_level_textfield, 1.0, "50");
        signal_level = new TextFieldController(signal_level_textfield, 1.0, "20");
        noise_level = new TextFieldController(noise_level_textfield, 1.0, "30");
        if (ini_path != null) {
            config_mgr = new ConfigManager(this, ini_path);
        } else {
            controller_enabled.set_value(false);
            this.quit_button.setEnabled(false);
        }
        periodic_timer = new java.util.Timer();
        periodic_timer.scheduleAtFixedRate(new PeriodicEvents(this), 500, timer_period_ms);
    }

    class PeriodicEvents extends TimerTask {

        JSigGenPanel parent;

        public PeriodicEvents(JSigGenPanel p) {
            parent = p;
        }

        public void run() {
            if (controller_enabled.get_value()) {
                if (generator == null) {
                    generator = new SignalGenerator(parent);
                    generator.start();
                }
            } else {
                stop_generator();
            }
            parent.data_rate_combobox.setEnabled(generator == null);
            parent.output_channel_combobox.setEnabled(generator == null);
        }
    }

    private void stop_generator() {
        if (generator != null) {
            generator.running = false;
            try {
                generator.join();
            } catch (Exception e) {
                System.out.println(e);
            }
            generator = null;
        }
    }

    private void find_source_mixers() {
        sourceLineInfo = new Line.Info(SourceDataLine.class);
        Mixer.Info[] mi = AudioSystem.getMixerInfo();
        source_mixers = new java.util.ArrayList<Mixer>();
        for (Mixer.Info m : mi) {
            Mixer mixer = AudioSystem.getMixer(m);
            if (mixer.isLineSupported(sourceLineInfo)) {
                source_mixers.add(mixer);
            }
        }
    }

    public void close() {
        stop_generator();
        if (config_mgr != null) {
            config_mgr.write_config_file();
        }
        System.exit(0);
    }

    public void help() {
        try {
            java.awt.Desktop.getDesktop().browse(java.net.URI.create("http://arachnoid.com/JSigGen"));
        } catch (Exception e) {
            System.out.println(e);
        }
    }

    public <T> void p(T s) {
        System.out.println(s);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        controller_panel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        controller_enable_checkbutton = new javax.swing.JCheckBox();
        jLabel2 = new javax.swing.JLabel();
        data_rate_combobox = new javax.swing.JComboBox();
        left_checkbox = new javax.swing.JCheckBox();
        right_checkbox = new javax.swing.JCheckBox();
        help_button = new javax.swing.JButton();
        quit_button = new javax.swing.JButton();
        jLabel11 = new javax.swing.JLabel();
        output_channel_combobox = new javax.swing.JComboBox();
        signal_panel = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        signal_enable_checkbox = new javax.swing.JCheckBox();
        jLabel12 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        frequency_textfield = new javax.swing.JTextField();
        signal_waveform_combobox = new javax.swing.JComboBox();
        jLabel5 = new javax.swing.JLabel();
        signal_level_textfield = new javax.swing.JTextField();
        modulation_panel = new javax.swing.JPanel();
        jLabel6 = new javax.swing.JLabel();
        modulation_enable_checkbox = new javax.swing.JCheckBox();
        am_fm_combobox = new javax.swing.JComboBox();
        jLabel7 = new javax.swing.JLabel();
        modulation_frequency_textfield = new javax.swing.JTextField();
        modulation_waveform_combobox = new javax.swing.JComboBox();
        jLabel8 = new javax.swing.JLabel();
        modulation_level_textfield = new javax.swing.JTextField();
        noise_panel = new javax.swing.JPanel();
        jLabel9 = new javax.swing.JLabel();
        noise_enable_checkbox = new javax.swing.JCheckBox();
        jLabel13 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        noise_level_textfield = new javax.swing.JTextField();

        setMinimumSize(new java.awt.Dimension(0, 0));
        setPreferredSize(new java.awt.Dimension(0, 0));
        setLayout(new java.awt.GridBagLayout());

        controller_panel.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(204, 0, 51), 2));
        controller_panel.setLayout(new java.awt.GridBagLayout());

        jLabel1.setFont(new java.awt.Font("Dialog", 1, 16));
        jLabel1.setForeground(new java.awt.Color(204, 0, 51));
        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel1.setText("Controller");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 2, 2);
        controller_panel.add(jLabel1, gridBagConstraints);

        controller_enable_checkbutton.setText("Enable");
        controller_enable_checkbutton.setToolTipText("Enable output data stream");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        controller_panel.add(controller_enable_checkbutton, gridBagConstraints);

        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel2.setText("Sample Rate: ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        controller_panel.add(jLabel2, gridBagConstraints);

        data_rate_combobox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        data_rate_combobox.setToolTipText("<html>Select data sampling rate in samples/second<br/>\n(while output is disabled)\n</html>");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        controller_panel.add(data_rate_combobox, gridBagConstraints);

        left_checkbox.setText("Left");
        left_checkbox.setToolTipText("Enable left channel audio");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        controller_panel.add(left_checkbox, gridBagConstraints);

        right_checkbox.setText("Right");
        right_checkbox.setToolTipText("Enable right channel audio");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        controller_panel.add(right_checkbox, gridBagConstraints);

        help_button.setText("Help");
        help_button.setToolTipText("Visit the JSigGen web page");
        help_button.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                help_buttonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        controller_panel.add(help_button, gridBagConstraints);

        quit_button.setText("Quit");
        quit_button.setToolTipText("Quit JSigGen");
        quit_button.setPreferredSize(null);
        quit_button.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                quit_buttonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        controller_panel.add(quit_button, gridBagConstraints);

        jLabel11.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel11.setText("Output channel: ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        controller_panel.add(jLabel11, gridBagConstraints);

        output_channel_combobox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        output_channel_combobox.setToolTipText("<html>Select audio output channel<br/>\n(while output is disabled)\n</html>");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        controller_panel.add(output_channel_combobox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 126;
        gridBagConstraints.ipady = -2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(controller_panel, gridBagConstraints);

        signal_panel.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(51, 153, 0), 2));
        signal_panel.setLayout(new java.awt.GridBagLayout());

        jLabel3.setFont(new java.awt.Font("Dialog", 1, 16));
        jLabel3.setForeground(new java.awt.Color(51, 153, 0));
        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel3.setText("Signal");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        signal_panel.add(jLabel3, gridBagConstraints);

        signal_enable_checkbox.setText("Enable");
        signal_enable_checkbox.setToolTipText("Enable signal");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        signal_panel.add(signal_enable_checkbox, gridBagConstraints);

        jLabel12.setMinimumSize(new java.awt.Dimension(52, 24));
        jLabel12.setPreferredSize(new java.awt.Dimension(52, 24));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        signal_panel.add(jLabel12, gridBagConstraints);

        jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel4.setText("Freq. Hz: ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        signal_panel.add(jLabel4, gridBagConstraints);

        frequency_textfield.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        frequency_textfield.setText("000000.0");
        frequency_textfield.setMinimumSize(new java.awt.Dimension(80, 20));
        frequency_textfield.setPreferredSize(new java.awt.Dimension(80, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        signal_panel.add(frequency_textfield, gridBagConstraints);

        signal_waveform_combobox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        signal_waveform_combobox.setToolTipText("Select signal waveform");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        signal_panel.add(signal_waveform_combobox, gridBagConstraints);

        jLabel5.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel5.setText("Level %: ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        signal_panel.add(jLabel5, gridBagConstraints);

        signal_level_textfield.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        signal_level_textfield.setText("000000.0");
        signal_level_textfield.setMinimumSize(new java.awt.Dimension(80, 20));
        signal_level_textfield.setPreferredSize(new java.awt.Dimension(80, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        signal_panel.add(signal_level_textfield, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(signal_panel, gridBagConstraints);

        modulation_panel.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(51, 51, 255), 2));
        modulation_panel.setLayout(new java.awt.GridBagLayout());

        jLabel6.setFont(new java.awt.Font("Dialog", 1, 16));
        jLabel6.setForeground(new java.awt.Color(0, 51, 204));
        jLabel6.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel6.setText("Modul");
        jLabel6.setToolTipText("Modulation");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        modulation_panel.add(jLabel6, gridBagConstraints);

        modulation_enable_checkbox.setText("Enable");
        modulation_enable_checkbox.setToolTipText("Enable modulation");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        modulation_panel.add(modulation_enable_checkbox, gridBagConstraints);

        am_fm_combobox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "AM", "FM", " " }));
        am_fm_combobox.setToolTipText("Select AM or FM modulation mode");
        am_fm_combobox.setMinimumSize(new java.awt.Dimension(50, 24));
        am_fm_combobox.setPreferredSize(new java.awt.Dimension(50, 24));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        modulation_panel.add(am_fm_combobox, gridBagConstraints);

        jLabel7.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel7.setText("Freq. Hz: ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        modulation_panel.add(jLabel7, gridBagConstraints);

        modulation_frequency_textfield.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        modulation_frequency_textfield.setText("000000.0");
        modulation_frequency_textfield.setMinimumSize(new java.awt.Dimension(80, 20));
        modulation_frequency_textfield.setPreferredSize(new java.awt.Dimension(80, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        modulation_panel.add(modulation_frequency_textfield, gridBagConstraints);

        modulation_waveform_combobox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        modulation_waveform_combobox.setToolTipText("Select modulation waveform");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        modulation_panel.add(modulation_waveform_combobox, gridBagConstraints);

        jLabel8.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel8.setText("Level %: ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        modulation_panel.add(jLabel8, gridBagConstraints);

        modulation_level_textfield.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        modulation_level_textfield.setText("000000.0");
        modulation_level_textfield.setMinimumSize(new java.awt.Dimension(80, 20));
        modulation_level_textfield.setPreferredSize(new java.awt.Dimension(80, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        modulation_panel.add(modulation_level_textfield, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(modulation_panel, gridBagConstraints);

        noise_panel.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(153, 0, 153), 2));
        noise_panel.setLayout(new java.awt.GridBagLayout());

        jLabel9.setFont(new java.awt.Font("Dialog", 1, 16));
        jLabel9.setForeground(new java.awt.Color(153, 0, 153));
        jLabel9.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel9.setText("Noise ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 3);
        noise_panel.add(jLabel9, gridBagConstraints);

        noise_enable_checkbox.setText("Enable");
        noise_enable_checkbox.setToolTipText("Enable white noise generator");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        noise_panel.add(noise_enable_checkbox, gridBagConstraints);

        jLabel13.setMinimumSize(new java.awt.Dimension(282, 20));
        jLabel13.setPreferredSize(new java.awt.Dimension(282, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        noise_panel.add(jLabel13, gridBagConstraints);

        jLabel10.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel10.setText("Level %: ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        noise_panel.add(jLabel10, gridBagConstraints);

        noise_level_textfield.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        noise_level_textfield.setText("000000.0");
        noise_level_textfield.setMaximumSize(new java.awt.Dimension(40, 20));
        noise_level_textfield.setMinimumSize(new java.awt.Dimension(80, 20));
        noise_level_textfield.setPreferredSize(new java.awt.Dimension(80, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        noise_panel.add(noise_level_textfield, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = -12;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(1, 1, 1, 1);
        add(noise_panel, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void help_buttonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_help_buttonMouseClicked
        help();
}//GEN-LAST:event_help_buttonMouseClicked

    private void quit_buttonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_quit_buttonMouseClicked
        close();
}//GEN-LAST:event_quit_buttonMouseClicked
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox am_fm_combobox;
    private javax.swing.JCheckBox controller_enable_checkbutton;
    private javax.swing.JPanel controller_panel;
    private javax.swing.JComboBox data_rate_combobox;
    private javax.swing.JTextField frequency_textfield;
    private javax.swing.JButton help_button;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JCheckBox left_checkbox;
    private javax.swing.JCheckBox modulation_enable_checkbox;
    private javax.swing.JTextField modulation_frequency_textfield;
    private javax.swing.JTextField modulation_level_textfield;
    private javax.swing.JPanel modulation_panel;
    private javax.swing.JComboBox modulation_waveform_combobox;
    private javax.swing.JCheckBox noise_enable_checkbox;
    private javax.swing.JTextField noise_level_textfield;
    private javax.swing.JPanel noise_panel;
    private javax.swing.JComboBox output_channel_combobox;
    private javax.swing.JButton quit_button;
    private javax.swing.JCheckBox right_checkbox;
    private javax.swing.JCheckBox signal_enable_checkbox;
    private javax.swing.JTextField signal_level_textfield;
    private javax.swing.JPanel signal_panel;
    private javax.swing.JComboBox signal_waveform_combobox;
    // End of variables declaration//GEN-END:variables
}
