/*
 * Decompiled with CFR 0.152.
 */
package jtides;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import jtides.MyJButton;
import jtides.SiteSet;
import jtides.TidesDoc;

public final class SiteDataDialog
extends JDialog {
    TidesDoc parent;
    private JButton OKBUtton;
    private JPanel jPanel1;
    private JTextArea outputArea;

    public SiteDataDialog(TidesDoc tidesDoc) {
        super(tidesDoc.main, "Site Information", false);
        this.parent = tidesDoc;
        this.initComponents();
        this.pack();
        this.setSize(500, 300);
        tidesDoc.main.tideComp.tweakFont(this.outputArea);
        Dimension dimension = tidesDoc.main.getSize();
        Point point = tidesDoc.main.getLocation();
        Dimension dimension2 = this.getSize();
        this.setLocation(point.x + (dimension.width - dimension2.width) / 2, point.y + (dimension.height - dimension2.height) / 2);
        this.setVisible(true);
        this.createData(tidesDoc.siteSet);
    }

    private void createData(SiteSet siteSet) {
        int n = 26;
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = this.parent.main.tideComp.parseDelimLine(siteSet.fullName, "\t");
        String[] stringArray = vector.toArray(new String[0]);
        this.insertPair(stringBuffer, "Site Name", siteSet.name, n, 0);
        this.insertPair(stringBuffer, "Data Type", stringArray[0].equals("T") ? "Tide" : "Current", n, 0);
        this.insertPair(stringBuffer, "Region", stringArray[1], n, 0);
        this.insertPair(stringBuffer, "State or Territory", stringArray[2], n, 0);
        this.insertPair(stringBuffer, "Position", this.parent.main.tideComp.FormatLatLng(siteSet.lat, siteSet.lng), n, 0);
        this.insertPair(stringBuffer, "Time Zone", "UTC" + this.parent.panel.plusSign((int)siteSet.tz), n, 0);
        this.insertPair(stringBuffer, "Data File", siteSet.dataFileName, n, 0);
        this.insertPair(stringBuffer, "Byte Position", stringArray[8], n, 0);
        this.insertPair(stringBuffer, "Harmonic Constants", "" + siteSet.constituentMax, n, 0);
        this.insertPair(stringBuffer, "Valid Prediction years", "" + siteSet.startYear + "-" + siteSet.endYear, n, 0);
        this.insertPair(stringBuffer, "Total indexed sites", "" + this.parent.main.tideComp.siteIndex.size(), n, 0);
        this.outputArea.setText(stringBuffer.toString());
    }

    private void insertPair(StringBuffer stringBuffer, String string, String string2, int n, int n2) {
        stringBuffer.append(this.parent.main.tideComp.padString(string, n, n2) + this.parent.main.tideComp.padString(string2, n, n2) + "\n");
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.OKBUtton = new MyJButton();
        this.outputArea = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SiteDataDialog.this.closeDialog(windowEvent);
            }
        });
        this.OKBUtton.setText("OK");
        this.OKBUtton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SiteDataDialog.this.OKBUttonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.OKBUtton);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.outputArea.setBackground(UIManager.getDefaults().getColor("CheckBox.background"));
        this.outputArea.setEditable(false);
        this.outputArea.setMargin(new Insets(8, 8, 8, 8));
        this.getContentPane().add((Component)this.outputArea, "Center");
    }

    private void OKBUttonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }
}

