/*
 * Decompiled with CFR 0.152.
 */
package jwx;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import jwx.ControlInterface;
import jwx.JWX;

public final class CalibrationController
implements ControlInterface {
    JWX parent;
    JTextField field;
    private String value;
    private double dvalue = 0.0;

    public CalibrationController(JTextField f, String s, JWX p) {
        this.parent = p;
        this.field = f;
        this.field.setText(s);
        this.input_changed();
        this.field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                CalibrationController.this.test_for_enter(evt);
            }
        });
    }

    private void test_for_enter(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            this.input_changed();
        }
    }

    private void input_changed() {
        try {
            this.value = this.field.getText();
            this.dvalue = Double.parseDouble(this.value);
            this.process_entry();
        }
        catch (NumberFormatException e) {
            this.dvalue = 0.0;
            this.process_entry();
        }
    }

    private void process_entry() {
        this.value = String.format("%.4e", this.dvalue);
        this.field.setText(this.value);
        this.parent.calibrate_control(1, 0.0, 0.0);
    }

    public String get_value() {
        return this.value;
    }

    public double get_dvalue() {
        return this.dvalue;
    }

    @Override
    public void set_value(String s) {
        this.field.setText(s);
        this.input_changed();
    }

    public void set_value(double v) {
        this.set_value("" + v);
    }

    public String toString() {
        return this.value;
    }
}

