/*
 * Decompiled with CFR 0.152.
 */
package jwx;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import jwx.ImagePanel;
import jwx.JWX;

public final class ChartPanel
extends JPanel {
    JWX parent;
    ImagePanel image_panel;
    boolean old_scaled;
    int old_cal_phase = -1;
    double calibration_val;
    static final long serialVersionUID = 18345L;
    private JScrollPane chart_scroll_pane;
    private JButton close_button;
    private JButton closeall_button;
    private JPanel control_panel;
    private JLabel data_label;
    private JButton invert_button;
    private JButton rotate_ccw_button;
    private JButton rotate_cw_button;
    private JButton save_button;

    public ChartPanel(JWX p, String path, double cal_val) {
        this.parent = p;
        this.calibration_val = cal_val;
        this.initComponents();
        this.image_panel = new ImagePanel(this, path);
        this.chart_scroll_pane.setViewportView(this.image_panel);
        this.old_scaled = !this.parent.fullscale.get_value();
    }

    public void save_file() {
        this.image_panel.save_file();
    }

    public Dimension get_view_size() {
        return this.chart_scroll_pane.getViewport().getExtentSize();
    }

    public JScrollBar get_vert_scroll_bar() {
        return this.chart_scroll_pane.getVerticalScrollBar();
    }

    public void perform_periodic() {
        boolean receiving;
        if (this.old_scaled != this.parent.scaled_images) {
            this.image_panel.set_image_scale();
            this.old_scaled = this.parent.scaled_images;
        }
        this.close_button.setEnabled(!(receiving = this.image_panel.receiving_fax()));
        this.rotate_cw_button.setEnabled(!receiving);
        this.rotate_ccw_button.setEnabled(!receiving);
        this.invert_button.setEnabled(!receiving);
        this.save_button.setEnabled(this.image_panel.get_changed());
        this.image_panel.scroll_test(false);
        this.calibrate_actions();
    }

    private void calibrate_actions() {
        if (this.parent.current_chart == this && this.old_cal_phase != this.parent.calibrate_phase) {
            this.old_cal_phase = this.parent.calibrate_phase;
            switch (this.old_cal_phase) {
                case 0: {
                    this.data_label.setOpaque(false);
                    this.data_label.setText("");
                    this.data_label.setToolTipText(this.image_panel.file.toString());
                    this.image_panel.setToolTipText("");
                    break;
                }
                case 1: {
                    this.data_label.setOpaque(true);
                    this.data_label.setBackground(Color.green);
                    this.data_label.setText("Calibrate 1: Right-click one end of a vertical feature.");
                    String tt = "<html>Calibrate 1: Right-click one end of a vertical feature<br/>or enter a value in the calibration window</html>";
                    this.data_label.setToolTipText(tt);
                    this.image_panel.setToolTipText(tt);
                    break;
                }
                case 2: {
                    this.data_label.setOpaque(true);
                    this.data_label.setBackground(Color.orange);
                    String tt = "Calibrate 2: Right-click the other end of the same vertical feature";
                    this.data_label.setText(tt);
                    this.image_panel.setToolTipText(tt);
                }
            }
        }
    }

    public void set_data_label(String s) {
        if (this.parent.calibrate_phase == 0) {
            this.data_label.setText(s);
        }
    }

    public void close() {
        this.image_panel.save_file();
        this.parent.remove_tab(this);
    }

    private void initComponents() {
        this.control_panel = new JPanel();
        this.data_label = new JLabel();
        this.rotate_ccw_button = new JButton();
        this.rotate_cw_button = new JButton();
        this.invert_button = new JButton();
        this.save_button = new JButton();
        this.close_button = new JButton();
        this.closeall_button = new JButton();
        this.chart_scroll_pane = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.control_panel.setLayout(new GridBagLayout());
        this.data_label.setText("...");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.control_panel.add((Component)this.data_label, gridBagConstraints);
        this.rotate_ccw_button.setText("Rotate CCW");
        this.rotate_ccw_button.setToolTipText("Rotate image counterclockwise");
        this.rotate_ccw_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChartPanel.this.rotate_ccw_buttonMouseClicked(evt);
            }
        });
        this.control_panel.add((Component)this.rotate_ccw_button, new GridBagConstraints());
        this.rotate_cw_button.setText("Rotate CW");
        this.rotate_cw_button.setToolTipText("Rotate Image clockwise");
        this.rotate_cw_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChartPanel.this.rotate_cw_buttonMouseClicked(evt);
            }
        });
        this.control_panel.add((Component)this.rotate_cw_button, new GridBagConstraints());
        this.invert_button.setText("Invert");
        this.invert_button.setToolTipText("Invert image (black <-> white)");
        this.invert_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChartPanel.this.invert_buttonMouseClicked(evt);
            }
        });
        this.control_panel.add((Component)this.invert_button, new GridBagConstraints());
        this.save_button.setText("Save");
        this.save_button.setToolTipText("Save without closing");
        this.save_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChartPanel.this.save_buttonMouseClicked(evt);
            }
        });
        this.control_panel.add((Component)this.save_button, new GridBagConstraints());
        this.close_button.setText("Close");
        this.close_button.setToolTipText("Save and close this chart");
        this.close_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChartPanel.this.close_buttonMouseClicked(evt);
            }
        });
        this.control_panel.add((Component)this.close_button, new GridBagConstraints());
        this.closeall_button.setText("Close All");
        this.closeall_button.setToolTipText("Save and close all inactive charts");
        this.closeall_button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChartPanel.this.closeall_buttonMouseClicked(evt);
            }
        });
        this.control_panel.add((Component)this.closeall_button, new GridBagConstraints());
        this.add((Component)this.control_panel, "South");
        this.chart_scroll_pane.setVerticalScrollBarPolicy(22);
        this.add((Component)this.chart_scroll_pane, "Center");
    }

    private void close_buttonMouseClicked(MouseEvent evt) {
        if (evt.getComponent().isEnabled()) {
            this.close();
        }
    }

    private void save_buttonMouseClicked(MouseEvent evt) {
        if (evt.getComponent().isEnabled()) {
            this.save_file();
        }
    }

    private void rotate_cw_buttonMouseClicked(MouseEvent evt) {
        if (evt.getComponent().isEnabled()) {
            this.image_panel.rotate_image(true);
        }
    }

    private void rotate_ccw_buttonMouseClicked(MouseEvent evt) {
        if (evt.getComponent().isEnabled()) {
            this.image_panel.rotate_image(false);
        }
    }

    private void invert_buttonMouseClicked(MouseEvent evt) {
        if (evt.getComponent().isEnabled()) {
            this.image_panel.invert_image();
        }
    }

    private void closeall_buttonMouseClicked(MouseEvent evt) {
        this.parent.close_inactive_charts(true);
    }
}

