/*
 * Decompiled with CFR 0.152.
 */
package jwx;

import java.awt.AWTException;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Robot;
import java.awt.event.ItemEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import jwx.CommonCode;
import jwx.ControlInterface;
import jwx.MyComboBoxRenderer;

public final class ComboBoxController
implements ControlInterface {
    JComboBox<String> box;
    int value = 0;
    double dvalue = 0.0;
    double percent_value = 0.0;
    ArrayList<String> tooltips = null;
    String prompt = null;

    public ComboBoxController(JComboBox<String> b, List<String> data, String sel, List<String> tips, String prompt) {
        this.setup(b, data, sel, tips, prompt);
    }

    public ComboBoxController(JComboBox<String> b, List<String> data, String sel) {
        this.setup(b, data, sel, null, null);
    }

    private void setup(JComboBox<String> b, List<String> data, String sel, List<String> tips, String prompt) {
        this.box = b;
        this.tooltips = new ArrayList();
        this.prompt = prompt;
        this.populate_combobox(data, sel, tips);
        this.box.setRenderer(new MyComboBoxRenderer(this.tooltips));
        this.box.addMouseWheelListener(this::mouse_wheel_event);
        this.box.addItemListener(this::item_state_changed);
        this.set_box_tooltip();
    }

    public void populate_combobox(List<String> data, String sel, List<String> tips) {
        int i;
        if (tips != null) {
            for (i = tips.size() - 1; i >= 0; --i) {
                this.tooltips.add(tips.get(i));
            }
        }
        this.box.removeAllItems();
        for (i = data.size() - 1; i >= 0; --i) {
            this.box.addItem(data.get(i));
        }
        this.set_value(sel);
    }

    private void mouse_wheel_event(MouseWheelEvent evt) {
        if (this.box.isEnabled()) {
            double n = evt.getWheelRotation() > 0 ? 1.0 : -1.0;
            n = evt.isShiftDown() ? n * 10.0 : n;
            n = evt.isControlDown() ? n * 10.0 : n;
            n = evt.isAltDown() ? n * 10.0 : n;
            int v = this.box.getSelectedIndex();
            v = (int)((double)v + n);
            v = this.check_range(v);
            this.box.setSelectedIndex(v);
            this.set_box_tooltip();
        }
    }

    private int check_range(int v) {
        int top = this.box.getItemCount();
        v = Math.min(top - 1, v);
        v = Math.max(0, v);
        return v;
    }

    private void item_state_changed(ItemEvent evt) {
        this.set_box_tooltip();
        String s = (String)this.box.getSelectedItem();
        this.scan_string(s);
    }

    private void scan_string(String s) {
        try {
            this.value = Integer.parseInt(s);
            this.dvalue = this.value;
            this.percent_value = (double)this.value / 100.0;
        }
        catch (NumberFormatException e) {
            System.out.println(e);
        }
    }

    private void set_box_tooltip() {
        int top = this.box.getItemCount();
        int i = this.box.getSelectedIndex();
        if (i >= 0 && i < top && this.tooltips != null && i < this.tooltips.size()) {
            String tip = this.tooltips.get(i);
            if (this.prompt != null) {
                tip = this.prompt + ": " + tip;
            }
            this.box.setToolTipText(tip);
            PointerInfo a = MouseInfo.getPointerInfo();
            Point b = a.getLocation();
            try {
                Robot r = new Robot();
                r.mouseMove(b.x, b.y - 1);
                r.mouseMove(b.x, b.y);
            }
            catch (AWTException e) {
                CommonCode.p(e);
            }
        }
    }

    public int get_value() {
        return this.value;
    }

    public double get_dvalue() {
        return this.dvalue;
    }

    public double get_percent_value() {
        return this.percent_value;
    }

    @Override
    public void set_value(String s) {
        this.box.setSelectedItem(s);
        String r = (String)this.box.getSelectedItem();
        if (!r.equals(s)) {
            this.box.setSelectedIndex(0);
            s = (String)this.box.getSelectedItem();
        }
        this.scan_string(s);
    }

    public String toString() {
        return Integer.toString(this.value);
    }
}

