/*
 * Decompiled with CFR 0.152.
 */
package jwx;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import jwx.ControlInterface;

public final class ConfigManager {
    String line_sep;
    String init_path;
    JFrame parent;
    Pattern pat;
    Matcher mat;
    ConcurrentSkipListMap<String, ControlInterface> map;

    public ConfigManager(JFrame p, String path) {
        this.parent = p;
        this.init_path = path;
        this.pat = Pattern.compile("\\s*(.+?)\\s*=\\s*(.+?)\\s*");
        this.line_sep = System.getProperty("line.separator");
        this.create_control_map();
        this.read_config_file();
    }

    private void create_control_map() {
        this.map = new ConcurrentSkipListMap();
        for (Field f : Arrays.asList(this.parent.getClass().getDeclaredFields())) {
            String name = f.getName();
            try {
                String t;
                Type o;
                Type[] type;
                Class<?> cls;
                Object obj = f.get(this.parent);
                if (obj == null || (cls = obj.getClass()) == null || (type = cls.getGenericInterfaces()).length <= 0 || (o = type[0]) == null || !(t = o.toString()).equals("interface jwx.ControlInterface")) continue;
                this.map.put(name, (ControlInterface)obj);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {}
        }
    }

    private void read_config_file() {
        block15: {
            try {
                File f = new File(this.init_path);
                if (!f.exists()) break block15;
                try (BufferedReader br = new BufferedReader(new FileReader(f));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        this.mat = this.pat.matcher(line);
                        if (!this.mat.matches()) continue;
                        this.map.get(this.mat.group(1)).set_value(this.mat.group(2));
                    }
                }
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
    }

    public void write_config_file() {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.init_path));){
            for (String key : this.map.keySet()) {
                String val = this.map.get(key).toString();
                bw.write(key + " = " + val + this.line_sep);
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }
}

