/*
 * Decompiled with CFR 0.152.
 */
package magiclantern;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Collections;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import magiclantern.CommonCode;
import magiclantern.FileComparatorNoCase;
import magiclantern.MagicLantern;

public final class ScaledImageGenerator
extends JPanel {
    MagicLantern parent;
    boolean threadRunning = false;
    int generatedImageCount = 0;
    String baseDir;
    String thumbPrefix = "thumb_";
    String scaledPrefix = "scaled_";
    String[] qualityLabels = new String[]{"Good", "Better", "Best"};
    Object[] rederingHints = new Object[]{RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR, RenderingHints.VALUE_INTERPOLATION_BILINEAR, RenderingHints.VALUE_INTERPOLATION_BICUBIC};
    Object renderHint;
    private JButton cancelButton;
    private JPanel controlPanel;
    private JButton generateImagesButton;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JScrollPane jScrollPane2;
    private JButton pickPathButton;
    private JRadioButton presentationRadioButton;
    private JComboBox qualityComboBox;
    private JTextArea scaleHelpTextArea;
    private ButtonGroup scalebuttonGroup;
    private JTextField scaledSizeTextField;
    private JProgressBar theProgressBar;
    private JPanel thumbnailPanel;
    private JRadioButton thumbnailRadioButton;

    public ScaledImageGenerator(MagicLantern magicLantern) {
        this.parent = magicLantern;
        this.initComponents();
        this.createHelpText();
        this.setScaleMode();
        this.setupQualityCombo();
        this.setPickPathButtonTip();
    }

    void setupQualityCombo() {
        CommonCode.populateComboBox(this.qualityComboBox, this.qualityLabels, this.parent.sv_scaleQualityIndex);
    }

    void actionQualityCombo(ActionEvent actionEvent) {
        if (!this.threadRunning && ((long)actionEvent.getModifiers() & 0x10L) != 0L) {
            this.parent.sv_scaleQualityIndex = this.qualityComboBox.getSelectedIndex();
        }
    }

    void setScaleMode() {
        if (!this.threadRunning) {
            if (this.parent.sv_thumbnailMode) {
                this.thumbnailRadioButton.setSelected(true);
            } else {
                this.presentationRadioButton.setSelected(true);
            }
            this.qualityComboBox.setEnabled(!this.parent.sv_thumbnailMode);
            this.setCurrentScaleEntry();
        }
    }

    void getScaleMode() {
        if (!this.threadRunning) {
            this.parent.sv_thumbnailMode = this.thumbnailRadioButton.isSelected();
            this.setScaleMode();
        }
    }

    String fetchStorageDirectory() {
        return this.parent.sv_thumbnailMode ? this.parent.thumbnailDir : this.parent.scaledImageDir;
    }

    int fetchImageScale() {
        return this.parent.sv_thumbnailMode ? this.parent.sv_thumbnailImageSize : this.parent.sv_scaledImageSize;
    }

    String fetchImageNamePrefix() {
        return this.parent.sv_thumbnailMode ? this.thumbPrefix : this.scaledPrefix;
    }

    void setCurrentScaleEntry() {
        this.scaledSizeTextField.setText("" + this.fetchImageScale());
        this.controlPanel.revalidate();
    }

    void createHelpText() {
        String string = "This generator creates scaled images for two purposes:\n\n";
        string = string + "   1. In thumbnail mode, the generator creates tiny versions of full-sized graphic images (called \"thumbnails\") needed by the MagicLantern editor.\n\n";
        string = string + "   2. In scaled mode, the generator creates scaled-down versions of large images for presentation purposes.\n\n";
        string = string + "Creating scaled images can take a lot of time, so it may be better to run this generator during idle time.\n\n";
        string = string + "As images are added to your collection, you may want to visit this dialog to create any missing scaled versions -- ";
        string = string + "the generator will only create scaled images that are missing or that are the wrong size.\n\n";
        string = string + "This dialog may also be used to change the size all scaled images or thumbnails at once, although because of the time and processing power required, ";
        string = string + "this is an activity best reserved for times when your computer isn't being stressed (this generator runs as a background task).\n\n";
        string = string + "To use the generator:\n\n";
        string = string + "   1. Choose a mode (thumbnail or scaled)\n";
        string = string + "   2. For the scaled image mode, choose a quality level (higher quality takes more time)\n";
        string = string + "   3. Choose a scale size or (preferred) accept the default\n";
        string = string + "   4. Choose a directory to scan (all subdirectories will be included)\n";
        string = string + "   5. Press \"Start\" to begin the process.\n";
        this.scaleHelpTextArea.setText(string);
        this.scaleHelpTextArea.setSelectionStart(0);
        this.scaleHelpTextArea.setSelectionEnd(0);
    }

    void setPickPathButtonTip() {
        String string = "Select a base directory for this activity";
        String string2 = this.parent.sv_scaledImageGeneratorDirectory;
        if (string2.length() > 0) {
            string = "<html>Choose a directory<br/>(now set to: " + string2 + ")</html>";
        }
        this.pickPathButton.setToolTipText(string);
    }

    void chooseDirectory() {
        if (!this.threadRunning) {
            JFileChooser jFileChooser = new JFileChooser();
            boolean bl = CommonCode.changeLookAndFeel(jFileChooser);
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setDialogTitle(this.parent.programName + ": Choose Scaled Image Base Directory");
            jFileChooser.setApproveButtonText("Accept");
            jFileChooser.setCurrentDirectory(new File(this.parent.sv_scaledImageGeneratorDirectory));
            int n2 = jFileChooser.showOpenDialog(this.parent);
            if (bl) {
                CommonCode.restoreSystemLookAndFeel();
            }
            if (n2 == 0) {
                try {
                    this.parent.sv_scaledImageGeneratorDirectory = jFileChooser.getSelectedFile().getCanonicalPath();
                    this.setPickPathButtonTip();
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
        }
    }

    void launchGenerateThread() {
        if (!this.threadRunning) {
            this.baseDir = CommonCode.strip(this.parent.sv_scaledImageGeneratorDirectory);
            if (this.baseDir.length() == 0) {
                CommonCode.beep();
                JOptionPane.showMessageDialog(this.parent, "Please choose a path for image processing", this.parent.programName + ": No Path Chosen", 2);
            } else {
                this.parent.sv_scaledImageGeneratorDirectory = this.baseDir;
                this.renderHint = this.rederingHints[this.parent.sv_scaleQualityIndex];
                this.updateScaleEntry();
                this.generatedImageCount = 0;
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        ScaledImageGenerator.this.generateThread();
                    }
                };
                thread.start();
            }
        }
    }

    void generateThread() {
        this.threadRunning = true;
        String string = this.parent.sv_thumbnailMode ? "thumbnails" : "scaled images";
        Vector<File> vector = new Vector<File>();
        vector = this.scanDir(vector, new File(this.baseDir));
        Collections.sort(vector, new FileComparatorNoCase());
        int n2 = vector.size();
        int n3 = this.fetchImageScale();
        String string2 = this.fetchImageNamePrefix();
        String string3 = this.fetchStorageDirectory();
        this.theProgressBar.setStringPainted(true);
        this.addProgressText(this.scaleHelpTextArea, "\nGenerating " + string + ":\n");
        for (int i2 = 0; i2 < vector.size() && this.threadRunning; ++i2) {
            int n4 = 100 * i2 / n2;
            this.theProgressBar.setValue(n4);
            this.theProgressBar.setString(n4 + "%");
            this.generateScaledImageTest(vector.get(i2), n3, string2, string3);
        }
        if (!this.threadRunning) {
            this.addProgressText(this.scaleHelpTextArea, "Operation canceled.");
        } else {
            this.addProgressText(this.scaleHelpTextArea, "Scanned " + vector.size() + " graphic files, created " + this.generatedImageCount + " " + string + ".");
        }
        if (this.parent.sv_thumbnailMode) {
            this.parent.updateThumbnails();
        }
        this.theProgressBar.setValue(0);
        this.theProgressBar.setString("Done.");
        this.threadRunning = false;
    }

    Vector<File> scanDir(Vector<File> vector, File file) {
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            String string = fileArray[i2].getName();
            if (fileArray[i2].isDirectory()) {
                if (string.equals(this.parent.thumbnailDir) || !this.parent.sv_thumbnailMode && string.matches(this.parent.scaledImageDir + ".*")) continue;
                vector = this.scanDir(vector, fileArray[i2]);
                continue;
            }
            if (!string.matches(this.parent.defaultFilenameFilter) || string.matches(this.thumbPrefix + ".*")) continue;
            vector.add(fileArray[i2]);
        }
        return vector;
    }

    void addProgressText(JTextArea jTextArea, String string) {
        jTextArea.append(string);
        jTextArea.setCaretPosition(jTextArea.getDocument().getLength() - 1);
    }

    void generateScaledImageTest(File file, int n2, String string, String string2) {
        String string3 = file.getParent();
        String string4 = file.getName();
        String string5 = string3 + this.parent.fileSep + string2;
        File file2 = new File(string5);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        String string6 = string5 + this.parent.fileSep + string + string4;
        try {
            File file3 = new File(string6);
            if (!file3.exists()) {
                this.createWriteScaledImage(string4, file, file3, n2);
            } else {
                BufferedImage bufferedImage = this.parent.readImage(file3);
                int n3 = ((Image)bufferedImage).getWidth(this);
                int n4 = ((Image)bufferedImage).getHeight(this);
                if (!(n3 == n2 && n4 <= n2 || n4 == n2 && n3 <= n2)) {
                    this.createWriteScaledImage(string4, file, file3, n2);
                } else if (file.lastModified() > file3.lastModified()) {
                    this.createWriteScaledImage(string4, file, file3, n2);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("generateScaledImageTest: " + exception);
        }
    }

    void createWriteScaledImage(String string, File file, File file2, int n2) {
        ++this.generatedImageCount;
        this.addProgressText(this.scaleHelpTextArea, "Creating " + file2.getPath() + "\n");
        try {
            Runtime.getRuntime().gc();
            BufferedImage bufferedImage = this.parent.readImage(file);
            if (bufferedImage != null) {
                BufferedImage bufferedImage2 = this.generateScaledImage(bufferedImage, n2);
                String string2 = string.replaceFirst(".*\\.(.*)", "$1");
                ImageIO.write((RenderedImage)bufferedImage2, string2, file2);
            }
        }
        catch (Exception exception) {
            System.out.println("createWriteScaledImage error: " + exception);
        }
    }

    BufferedImage generateScaledImage(BufferedImage bufferedImage, int n2) {
        int n3 = bufferedImage.getHeight(null);
        int n4 = bufferedImage.getWidth(null);
        double d2 = (double)n2 / (double)(n4 > n3 ? n4 : n3);
        int n5 = (int)((double)n3 * d2 + 0.5);
        int n6 = (int)((double)n4 * d2 + 0.5);
        int n7 = bufferedImage.getTransparency() == 1 ? 1 : 2;
        BufferedImage bufferedImage2 = new BufferedImage(n6, n5, n7);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        if (!this.parent.sv_thumbnailMode) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.renderHint);
        }
        graphics2D.drawImage(bufferedImage, 0, 0, n6, n5, this.parent);
        graphics2D.dispose();
        return bufferedImage2;
    }

    void updateScaleEntry() {
        if (!this.threadRunning) {
            try {
                int n2 = Integer.parseInt(this.scaledSizeTextField.getText());
                if (n2 > 0) {
                    if (this.parent.sv_thumbnailMode) {
                        this.parent.sv_thumbnailImageSize = n2;
                    } else {
                        this.parent.sv_scaledImageSize = n2;
                    }
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
                this.setCurrentScaleEntry();
            }
        }
    }

    void actOnKeyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n') {
            this.updateScaleEntry();
        }
    }

    void cancelGenerator() {
        this.threadRunning = false;
    }

    private void initComponents() {
        this.scalebuttonGroup = new ButtonGroup();
        this.thumbnailPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.scaleHelpTextArea = new JTextArea();
        this.controlPanel = new JPanel();
        this.thumbnailRadioButton = new JRadioButton();
        this.presentationRadioButton = new JRadioButton();
        this.qualityComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.scaledSizeTextField = new JTextField();
        this.pickPathButton = new JButton();
        this.generateImagesButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel2 = new JPanel();
        this.theProgressBar = new JProgressBar();
        this.setMinimumSize(new Dimension(541, 200));
        this.setPreferredSize(new Dimension(541, 200));
        this.setLayout(new GridBagLayout());
        this.thumbnailPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.thumbnailPanel.setLayout(new GridBagLayout());
        this.jLabel2.setText("<html><b>Scaled Image Generator</b></html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.thumbnailPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jScrollPane2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.scaleHelpTextArea.setColumns(20);
        this.scaleHelpTextArea.setEditable(false);
        this.scaleHelpTextArea.setLineWrap(true);
        this.scaleHelpTextArea.setRows(5);
        this.scaleHelpTextArea.setWrapStyleWord(true);
        this.scaleHelpTextArea.setMargin(new Insets(4, 4, 4, 4));
        this.jScrollPane2.setViewportView(this.scaleHelpTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel4.add((Component)this.jScrollPane2, gridBagConstraints);
        this.controlPanel.setBackground(new Color(231, 198, 253));
        this.controlPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.thumbnailRadioButton.setBackground(new Color(231, 198, 253));
        this.scalebuttonGroup.add(this.thumbnailRadioButton);
        this.thumbnailRadioButton.setSelected(true);
        this.thumbnailRadioButton.setText("Thumb");
        this.thumbnailRadioButton.setToolTipText("Create tiny images (\"thumbnails\") for use with the editor");
        this.thumbnailRadioButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ScaledImageGenerator.this.thumbnailRadioButtonMouseClicked(mouseEvent);
            }
        });
        this.controlPanel.add(this.thumbnailRadioButton);
        this.presentationRadioButton.setBackground(new Color(231, 198, 253));
        this.scalebuttonGroup.add(this.presentationRadioButton);
        this.presentationRadioButton.setText("Scaled");
        this.presentationRadioButton.setToolTipText("Create scaled-down images for use in slide shows");
        this.presentationRadioButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ScaledImageGenerator.this.presentationRadioButtonMouseClicked(mouseEvent);
            }
        });
        this.controlPanel.add(this.presentationRadioButton);
        this.qualityComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.qualityComboBox.setToolTipText("Select the quality level for the scaled mode");
        this.qualityComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScaledImageGenerator.this.qualityComboBoxActionPerformed(actionEvent);
            }
        });
        this.controlPanel.add(this.qualityComboBox);
        this.jLabel3.setText("Scale:");
        this.jLabel3.setToolTipText("Enter an image scale in pixels");
        this.controlPanel.add(this.jLabel3);
        this.jLabel3.getAccessibleContext().setAccessibleName("");
        this.scaledSizeTextField.setHorizontalAlignment(4);
        this.scaledSizeTextField.setToolTipText("<html>Only change this if you understand the implications.<br/>\nRecreating a large set of images can take a long time.</html>");
        this.scaledSizeTextField.setMinimumSize(new Dimension(50, 27));
        this.scaledSizeTextField.setPreferredSize(new Dimension(50, 27));
        this.scaledSizeTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                ScaledImageGenerator.this.scaledSizeTextFieldKeyTyped(keyEvent);
            }
        });
        this.controlPanel.add(this.scaledSizeTextField);
        this.pickPathButton.setIcon(new ImageIcon(this.getClass().getResource("/magiclantern/icons/document-open.png")));
        this.pickPathButton.setText("Path");
        this.pickPathButton.setToolTipText("Select a base directory for this activity");
        this.pickPathButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ScaledImageGenerator.this.pickPathButtonMouseClicked(mouseEvent);
            }
        });
        this.controlPanel.add(this.pickPathButton);
        this.generateImagesButton.setText("Start");
        this.generateImagesButton.setToolTipText("Start the generator");
        this.generateImagesButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ScaledImageGenerator.this.generateImagesButtonMouseClicked(mouseEvent);
            }
        });
        this.controlPanel.add(this.generateImagesButton);
        this.cancelButton.setText("Stop");
        this.cancelButton.setToolTipText("Stop/cancel the generation");
        this.cancelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ScaledImageGenerator.this.cancelButtonMouseClicked(mouseEvent);
            }
        });
        this.controlPanel.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel4.add((Component)this.controlPanel, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.jPanel2.add((Component)this.theProgressBar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        this.thumbnailPanel.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.25;
        this.add((Component)this.thumbnailPanel, gridBagConstraints);
    }

    private void pickPathButtonMouseClicked(MouseEvent mouseEvent) {
        this.chooseDirectory();
    }

    private void generateImagesButtonMouseClicked(MouseEvent mouseEvent) {
        this.launchGenerateThread();
    }

    private void scaledSizeTextFieldKeyTyped(KeyEvent keyEvent) {
        this.actOnKeyTyped(keyEvent);
    }

    private void cancelButtonMouseClicked(MouseEvent mouseEvent) {
        this.cancelGenerator();
    }

    private void thumbnailRadioButtonMouseClicked(MouseEvent mouseEvent) {
        this.getScaleMode();
    }

    private void presentationRadioButtonMouseClicked(MouseEvent mouseEvent) {
        this.getScaleMode();
    }

    private void qualityComboBoxActionPerformed(ActionEvent actionEvent) {
        this.actionQualityCombo(actionEvent);
    }
}

