/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package magiclantern;

import javax.swing.*;
import java.io.*;
import java.awt.event.*;

/**
 *
 * @author lutusp
 */
final public class EditBrowsePanel extends EditBrowsePanelCoreRoutines {

    /** Creates new form EditBrowsePanel */
    public EditBrowsePanel(MagicLantern p, EditBase b) {
        super(p, b);
        initComponents();
        initialize(editSelectorList, editPopupMenu, null);

        //readGraphicDirectory(parent.programValues.editSearchDirectory);
        readBrowseFile();
        setupTooltips(true);
        updateCutCopyPasteButtons();
        editList.revalidate();
        // set this flag so we can operate
        // with no open file
        activeFile = "";
    }

    void readImageDirectory() {
        JFileChooser chooser = new JFileChooser();
        // avoid the GTK L&F terrible appearance
        // for this one component
        boolean changed = CommonCode.changeLookAndFeel(chooser);
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        chooser.setDialogTitle(parent.programName + ": Choose Graphic Directory");
        chooser.setApproveButtonText("Read");
        chooser.setCurrentDirectory(new File(parent.programValues.editSearchDirectory));
        int returnVal = chooser.showOpenDialog(parent);
        if (changed) {
            CommonCode.restoreSystemLookAndFeel();
        }
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            try {
                parent.programValues.editSearchDirectory = chooser.getSelectedFile().getCanonicalPath();
                //System.out.println(parent.programValues.editSearchDirectory);
                readGraphicDirectory(parent.programValues.editSearchDirectory);
            } catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    void clearBrowseList() {
        pushUndo();
        editListModel.removeAllElements();
        contentLabel.setText("");
        reformatDisplay();
    }

    void readGraphicDirectory(String path) {
        if (editListModel.size() > 0) {
            pushUndo();
        }
        File f = new File(path);
        MyFileNameFilter fnf = new MyFileNameFilter(parent.defaultFilenameFilter);
        String array[] = f.list(fnf);
        populateControl(path, array);
        updateShowDisplay();
    }

    @Override
    void updateShowDisplay() {
        contentLabel.setText(editListModel.size() + " slides");
    }

    void handleKeyPressed(KeyEvent evt) {
        String kcode = KeyEvent.getKeyText(evt.getKeyCode());
        String mcode = KeyEvent.getKeyModifiersText(evt.getModifiers());
        String key = mcode + "+" + kcode;
        if (key.equals("Ctrl+X")) {
            cutAction();
        } else if (key.equals("Ctrl+C")) {
            copyAction();
        } else if (key.equals("Ctrl+V")) {
            pasteAction();
        } else if (key.equals("Ctrl+Z")) {
            undo();
        } else if (key.equals("Ctrl+Shift+Z")) {
            redo();
        }
    }

    @Override
    void updateButtons() {
        UndoButton.setEnabled(undoStack.size() > 0);
        RedoButton.setEnabled(redoStack.size() > 0);
    }

    void updateCutCopyPasteButtons() {
        super.updateCutCopyPasteButtons(cutMenuItem,copyMenuItem, pasteMenuItem,cutButton,copyButton,pasteButton);
    }

    // save the contents of the browse screen
    void saveBrowseFile() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < editListModel.size(); i++) {
            EditCellDatum ecd = (EditCellDatum) editListModel.get(i);
            sb.append(ecd.getPath() + parent.lineSep);
        }
        CommonCode.saveTextFile(parent,sb.toString(), parent.browseContentPath, false);
    }

    void readBrowseFile() {
        String data = CommonCode.readTextFile(parent.browseContentPath, parent.lineSep);
        if (data != null) {
            String array[] = data.split("\n");
            for (int i = 0; i < array.length; i++) {
                String fn = CommonCode.strip(array[i]);
                addListItem(fn);
            }
            reformatDisplay();
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        editPopupMenu = new javax.swing.JPopupMenu();
        infoMenuItem = new javax.swing.JMenuItem();
        cutMenuItem = new javax.swing.JMenuItem();
        copyMenuItem = new javax.swing.JMenuItem();
        pasteMenuItem = new javax.swing.JMenuItem();
        centerPanel = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        editSelectorList = new javax.swing.JList();
        jToolBar1 = new javax.swing.JToolBar();
        fileButton = new javax.swing.JButton();
        clearButton = new javax.swing.JButton();
        UndoButton = new javax.swing.JButton();
        RedoButton = new javax.swing.JButton();
        cutButton = new javax.swing.JButton();
        copyButton = new javax.swing.JButton();
        pasteButton = new javax.swing.JButton();
        contentLabel = new javax.swing.JLabel();

        infoMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/dialog-question.png"))); // NOI18N
        infoMenuItem.setText("Info");
        infoMenuItem.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                infoMenuItemMousePressed(evt);
            }
        });
        infoMenuItem.addMenuKeyListener(new javax.swing.event.MenuKeyListener() {
            public void menuKeyPressed(javax.swing.event.MenuKeyEvent evt) {
            }
            public void menuKeyReleased(javax.swing.event.MenuKeyEvent evt) {
            }
            public void menuKeyTyped(javax.swing.event.MenuKeyEvent evt) {
                infoMenuItemMenuKeyTyped(evt);
            }
        });
        editPopupMenu.add(infoMenuItem);

        cutMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/edit-cut.png"))); // NOI18N
        cutMenuItem.setMnemonic('t');
        cutMenuItem.setText("Cut");
        cutMenuItem.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                cutMenuItemMousePressed(evt);
            }
        });
        editPopupMenu.add(cutMenuItem);

        copyMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/edit-copy.png"))); // NOI18N
        copyMenuItem.setMnemonic('y');
        copyMenuItem.setText("Copy");
        copyMenuItem.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                copyMenuItemMousePressed(evt);
            }
        });
        editPopupMenu.add(copyMenuItem);

        pasteMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/edit-paste.png"))); // NOI18N
        pasteMenuItem.setMnemonic('p');
        pasteMenuItem.setText("Paste");
        pasteMenuItem.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                pasteMenuItemMousePressed(evt);
            }
        });
        editPopupMenu.add(pasteMenuItem);

        setLayout(new java.awt.BorderLayout());

        centerPanel.setLayout(new java.awt.GridBagLayout());

        jScrollPane1.setFocusable(false);

        editSelectorList.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        editSelectorList.setDragEnabled(true);
        editSelectorList.setLayoutOrientation(javax.swing.JList.HORIZONTAL_WRAP);
        editSelectorList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                editSelectorListValueChanged(evt);
            }
        });
        editSelectorList.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                editSelectorListKeyPressed(evt);
            }
        });
        jScrollPane1.setViewportView(editSelectorList);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        centerPanel.add(jScrollPane1, gridBagConstraints);

        add(centerPanel, java.awt.BorderLayout.CENTER);

        jToolBar1.setRollover(true);
        jToolBar1.setFocusable(false);

        fileButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/document-open.png"))); // NOI18N
        fileButton.setToolTipText("Open a directory of images");
        fileButton.setFocusable(false);
        fileButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        fileButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        fileButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                fileButtonMouseClicked(evt);
            }
        });
        jToolBar1.add(fileButton);

        clearButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/edit-clear.png"))); // NOI18N
        clearButton.setToolTipText("Clear this list");
        clearButton.setFocusable(false);
        clearButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        clearButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        clearButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                clearButtonMouseClicked(evt);
            }
        });
        jToolBar1.add(clearButton);

        UndoButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/edit-undo.png"))); // NOI18N
        UndoButton.setToolTipText("Undo last action (Ctrl+Z)");
        UndoButton.setEnabled(false);
        UndoButton.setFocusable(false);
        UndoButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        UndoButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        UndoButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                UndoButtonMouseClicked(evt);
            }
        });
        jToolBar1.add(UndoButton);

        RedoButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/edit-redo.png"))); // NOI18N
        RedoButton.setToolTipText("Redo last action (Ctrl+Shift+Z)");
        RedoButton.setEnabled(false);
        RedoButton.setFocusable(false);
        RedoButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        RedoButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        RedoButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                RedoButtonMouseClicked(evt);
            }
        });
        jToolBar1.add(RedoButton);

        cutButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/edit-cut.png"))); // NOI18N
        cutButton.setToolTipText("Cut (Ctrl+X)");
        cutButton.setFocusable(false);
        cutButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        cutButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        cutButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                cutButtonMouseClicked(evt);
            }
        });
        jToolBar1.add(cutButton);

        copyButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/edit-copy.png"))); // NOI18N
        copyButton.setToolTipText("Copy (Ctrl+C)");
        copyButton.setFocusable(false);
        copyButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        copyButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        copyButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                copyButtonMouseClicked(evt);
            }
        });
        jToolBar1.add(copyButton);

        pasteButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/magiclantern/icons/edit-paste.png"))); // NOI18N
        pasteButton.setToolTipText("Paste (Ctrl+V)");
        pasteButton.setFocusable(false);
        pasteButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        pasteButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        pasteButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                pasteButtonMouseClicked(evt);
            }
        });
        jToolBar1.add(pasteButton);

        contentLabel.setToolTipText("Slide count");
        jToolBar1.add(contentLabel);

        add(jToolBar1, java.awt.BorderLayout.NORTH);
    }// </editor-fold>//GEN-END:initComponents

    private void fileButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_fileButtonMouseClicked
        // TODO add your handling code here:
        readImageDirectory();
    }//GEN-LAST:event_fileButtonMouseClicked

    private void cutMenuItemMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_cutMenuItemMousePressed
        // TODO add your handling code here:
        cutAction();
}//GEN-LAST:event_cutMenuItemMousePressed

    private void copyMenuItemMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_copyMenuItemMousePressed
        // TODO add your handling code here:
        copyAction();
}//GEN-LAST:event_copyMenuItemMousePressed

    private void editSelectorListKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_editSelectorListKeyPressed
        // TODO add your handling code here:
        handleKeyPressed(evt);
    }//GEN-LAST:event_editSelectorListKeyPressed

    private void UndoButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_UndoButtonMouseClicked
        // TODO add your handling code here:
        undo();
}//GEN-LAST:event_UndoButtonMouseClicked

    private void RedoButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_RedoButtonMouseClicked
        // TODO add your handling code here:
        redo();
}//GEN-LAST:event_RedoButtonMouseClicked

    private void pasteMenuItemMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_pasteMenuItemMousePressed
        // TODO add your handling code here:
        pasteAction();
}//GEN-LAST:event_pasteMenuItemMousePressed

    private void cutButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_cutButtonMouseClicked
        // TODO add your handling code here:
        cutAction();
    }//GEN-LAST:event_cutButtonMouseClicked

    private void copyButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_copyButtonMouseClicked
        // TODO add your handling code here:
        copyAction();
    }//GEN-LAST:event_copyButtonMouseClicked

    private void pasteButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_pasteButtonMouseClicked
        // TODO add your handling code here:
        pasteAction();
    }//GEN-LAST:event_pasteButtonMouseClicked

    private void clearButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_clearButtonMouseClicked
        // TODO add your handling code here:
        clearBrowseList();
    }//GEN-LAST:event_clearButtonMouseClicked

    private void infoMenuItemMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_infoMenuItemMousePressed
        // TODO add your handling code here:
        showImageInfo();
    }//GEN-LAST:event_infoMenuItemMousePressed

    private void infoMenuItemMenuKeyTyped(javax.swing.event.MenuKeyEvent evt) {//GEN-FIRST:event_infoMenuItemMenuKeyTyped
        // TODO add your handling code here:
    }//GEN-LAST:event_infoMenuItemMenuKeyTyped

    private void editSelectorListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_editSelectorListValueChanged
        // TODO add your handling code here:
        updateCutCopyPasteButtons();
    }//GEN-LAST:event_editSelectorListValueChanged

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton RedoButton;
    private javax.swing.JButton UndoButton;
    private javax.swing.JPanel centerPanel;
    private javax.swing.JButton clearButton;
    private javax.swing.JLabel contentLabel;
    private javax.swing.JButton copyButton;
    protected javax.swing.JMenuItem copyMenuItem;
    private javax.swing.JButton cutButton;
    protected javax.swing.JMenuItem cutMenuItem;
    protected javax.swing.JPopupMenu editPopupMenu;
    private javax.swing.JList editSelectorList;
    private javax.swing.JButton fileButton;
    private javax.swing.JMenuItem infoMenuItem;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JToolBar jToolBar1;
    private javax.swing.JButton pasteButton;
    protected javax.swing.JMenuItem pasteMenuItem;
    // End of variables declaration//GEN-END:variables
}
