/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

package magiclantern;

import javax.swing.*;
import java.awt.*;
import java.io.*;
import javax.imageio.*;

/**
 *
 * @author lutusp
 */
final public class EditCellDatum extends Component {

    MagicLantern parent;
    EditBrowsePanelCoreRoutines editPanel;
    ImageIcon imageIcon = null;
    File file = null;
    String path;
    String name;
    Thread thumbnailThread = null;
    boolean valid = false;

    public EditCellDatum(MagicLantern p, EditBrowsePanelCoreRoutines ep, String path) {
        parent = p;
        editPanel = ep;
        this.path = path;
        try {
            valid = path.matches(parent.defaultFilenameFilter);
            if (valid) {
                testLoadThumbnail();
            }
        } catch (Exception e) {
            System.out.println("EditCellDatum: " + e);
        }
    }

    // thumbnail file may not exist or may not be
    // right size, find out

    public void testLoadThumbnail() {
        file = new File(path);
        name = file.getName();
        String fpath = file.getParent();
        String tp = fpath + parent.fileSep + parent.thumbnailDir;
        String tpa = tp + parent.fileSep + "thumb_" + name;
        //System.out.println(tpa);
        File ftpa = new File(tpa);
        if (ftpa.exists()) {
            try {
                Image im = parent.readImage(ftpa);
                // test for correct size
                int w = im.getWidth(this);
                int h = im.getHeight(this);
                int ths = parent.programValues.thumbnailImageSize;
                if((w == ths && h <= ths) || (h == ths && w <= ths)) {
                    imageIcon = new ImageIcon(im);
                }
            } catch (Exception e) {
                System.out.println("createThumbnail: " + e);
            }
        }
    }

    public File getFile() {
        return file;
    }

    public String getPath() {
        return path;
    }

    public String getName() {
        return name;
    }

    public ImageIcon getImageIcon() {
        return imageIcon;
    }

    public boolean valid() {
        return valid;
    }
}
