/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
package magiclantern;

import java.awt.*;

/**
 *
 * @author lutusp
 */
final public class ProgramValues {
    // all must be declared public
    public boolean thumbnailMode = true; // false = scaled image mode
    public int thumbnailImageSize = 120; // the box in which a thumbnail fits
    public int scaledImageSize = 1280; // the box in which a scaled image fits
    public int scaleQualityIndex = 0;
    public int currentTab = 3; // of main tabbed pane
    public int screenState = 0; // small display
    public int showIndex = 0; // index to slide show names
    public int showListIndex = 0; // index to one of 2 slide lists
    public int show0Index = 0; // slide index in show 0
    public int show1Index = 0;// slide index in show 1
    public int dividerLocation = 400; // on editing display
    public int editColumns = 3; // of thumbnails in editor
    public boolean editWhiteBackground = false;
    public int editSlideDurationSeconds = 22; // to estimate show time
    public int autoShowSlideDurationSeconds = 15; // actual auso show duration
    public boolean autoRepeat = false; // repeat auto show
    public boolean autoShow = false; // auto show is running
    public boolean fadeMode = false; // transition fade
    public int fadeDurationMilliseconds = 500;
    public int fadeSteps = 20;
    public String editSearchDirectory = ""; // for right-hand pane contents
    public String editSelectedShow = "";
    public String scaledImageGeneratorDirectory = "";
    public Rectangle screenBounds = new Rectangle(0,0,800,600); // default size
}
