/***************************************************************************
 *   Copyright (C) 2009 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
package magiclantern;

import java.awt.event.*;
import javax.swing.*;
import java.awt.*;

/**
 *
 * @author lutusp
 */
final public class SetupControlPanel extends javax.swing.JPanel {

    MagicLantern parent;

    /** Creates new form SetupControlPanel */
    public SetupControlPanel(MagicLantern p) {
        parent = p;
        initComponents();
        setupDefaults();
        updateMemStats();
    }

    void setupDefaults() {
        slideDurationTextField.setText("" + parent.programValues.autoShowSlideDurationSeconds);
        transitionStepsTextField.setText("" + parent.programValues.fadeSteps);
        transitionDurationTextField.setText("" + parent.programValues.fadeDurationMilliseconds);
        fadeEffectCheckBox.setSelected(parent.programValues.fadeMode);
        whiteBackgroundCheckBox.setSelected(parent.programValues.editWhiteBackground);
    }

    void readAllEntries() {
        parent.programValues.autoShowSlideDurationSeconds = getIntEntry(slideDurationTextField, parent.programValues.autoShowSlideDurationSeconds);
        parent.programValues.fadeSteps = getIntEntry(transitionStepsTextField, parent.programValues.fadeSteps);
        parent.programValues.fadeDurationMilliseconds = getIntEntry(transitionDurationTextField, parent.programValues.fadeDurationMilliseconds);
        setupDefaults();
    }

    int getIntEntry(JTextField area, int dv) {
        try {
            int v = Integer.parseInt(area.getText());
            if (v > 0) {
                dv = v;

            }
        } catch (Exception e) {
            System.out.println(e);
            area.setText("" + dv);
        }
        return dv;
    }

    void updateIfReturnPressed(KeyEvent evt, int n) {
        if (evt.getKeyChar() == '\n') {
            readAllEntries();
        }
    }

    void updateFadeEffect() {
        parent.programValues.fadeMode = fadeEffectCheckBox.isSelected();
    }

    void updateBlackEditBackground() {
        parent.programValues.editWhiteBackground = whiteBackgroundCheckBox.isSelected();
        parent.editBase.editPanel.setEditRenderer();
        parent.editBase.browsePanel.setEditRenderer();
    }

    public void updateMemStats() {
        Runtime.getRuntime().gc();
        long free = Runtime.getRuntime().freeMemory();
        long allocated = Runtime.getRuntime().totalMemory();
        long max = Runtime.getRuntime().maxMemory();
        allocatedLabel.setText(CommonCode.createDecimalFormat(allocated));
        freeLabel.setText(CommonCode.createDecimalFormat(free));
        maximumLabel.setText(CommonCode.createDecimalFormat(max));
        Color fc = Color.black;
        String stat = "Status: sufficient memory.";
        // if allocated is greater than 85% of max memory
        if(((double)allocated/max) > 0.85) {
            fc = Color.red;
            stat = "Status: marginal memory.";
        }
        allocatedLabel.setForeground(fc);
        freeLabel.setForeground(fc);
        maximumLabel.setForeground(fc);
        memStatLabel.setText(stat);
        memStatLabel.setForeground(fc);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        topInnerPanel = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        slideDurationTextField = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        transitionDurationTextField = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        transitionStepsTextField = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        whiteBackgroundCheckBox = new javax.swing.JCheckBox();
        fadeEffectCheckBox = new javax.swing.JCheckBox();
        updateButton = new javax.swing.JButton();
        memoryPanel = new javax.swing.JPanel();
        maximumLabel = new javax.swing.JLabel();
        updateMemoryButton = new javax.swing.JButton();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        freeLabel = new javax.swing.JLabel();
        allocatedLabel = new javax.swing.JLabel();
        memStatLabel = new javax.swing.JLabel();

        setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        setMinimumSize(new java.awt.Dimension(488, 100));
        setPreferredSize(new java.awt.Dimension(369, 100));
        setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("<html><b>Set Up Controls</b></html>");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(jLabel1, gridBagConstraints);

        jPanel1.setPreferredSize(new java.awt.Dimension(351, 8));
        jPanel1.setLayout(new java.awt.GridBagLayout());

        topInnerPanel.setBackground(new java.awt.Color(200, 255, 200));
        topInnerPanel.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        topInnerPanel.setMinimumSize(new java.awt.Dimension(464, 100));
        topInnerPanel.setPreferredSize(new java.awt.Dimension(538, 100));
        topInnerPanel.setLayout(new java.awt.GridBagLayout());

        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel2.setText("Auto show slide duration seconds:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 2, 2, 2);
        topInnerPanel.add(jLabel2, gridBagConstraints);

        slideDurationTextField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        slideDurationTextField.setText("jTextField1");
        slideDurationTextField.setToolTipText("Enter a slide duration for the automatic slide show feature");
        slideDurationTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                slideDurationTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 2);
        topInnerPanel.add(slideDurationTextField, gridBagConstraints);

        jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel4.setText("Transition fade duration (milliseconds):");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 2, 2, 2);
        topInnerPanel.add(jLabel4, gridBagConstraints);

        transitionDurationTextField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        transitionDurationTextField.setText("jTextField2");
        transitionDurationTextField.setToolTipText("Enter a duration in milliseconds for the fade-effect slide transition");
        transitionDurationTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                transitionDurationTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 2);
        topInnerPanel.add(transitionDurationTextField, gridBagConstraints);

        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel3.setText("Transition fade steps:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 2, 2, 2);
        topInnerPanel.add(jLabel3, gridBagConstraints);

        transitionStepsTextField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        transitionStepsTextField.setText("jTextField3");
        transitionStepsTextField.setToolTipText("Enter the number of steps in the fade-effect slide transition");
        transitionStepsTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                transitionStepsTextFieldKeyTyped(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 2);
        topInnerPanel.add(transitionStepsTextField, gridBagConstraints);

        jPanel2.setBackground(new java.awt.Color(200, 255, 200));
        jPanel2.setLayout(new java.awt.GridBagLayout());

        whiteBackgroundCheckBox.setBackground(new java.awt.Color(200, 255, 200));
        whiteBackgroundCheckBox.setText("White edit background");
        whiteBackgroundCheckBox.setToolTipText("Change the editor's default black background");
        whiteBackgroundCheckBox.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                whiteBackgroundCheckBoxMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel2.add(whiteBackgroundCheckBox, gridBagConstraints);

        fadeEffectCheckBox.setBackground(new java.awt.Color(200, 255, 200));
        fadeEffectCheckBox.setText("Enable fade effect");
        fadeEffectCheckBox.setToolTipText("<html>This is a nice transition, but it requires a fast<br/>computer when displaying large images.</html>");
        fadeEffectCheckBox.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                fadeEffectCheckBoxMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel2.add(fadeEffectCheckBox, gridBagConstraints);

        updateButton.setText("Commit");
        updateButton.setToolTipText("Press to commit your configuration changes");
        updateButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                updateButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add(updateButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.weighty = 1.0;
        topInnerPanel.add(jPanel2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel1.add(topInnerPanel, gridBagConstraints);

        memoryPanel.setBackground(new java.awt.Color(200, 240, 255));
        memoryPanel.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        memoryPanel.setMinimumSize(new java.awt.Dimension(321, 75));
        memoryPanel.setPreferredSize(new java.awt.Dimension(321, 75));
        memoryPanel.setLayout(new java.awt.GridBagLayout());

        maximumLabel.setText("0");
        maximumLabel.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        memoryPanel.add(maximumLabel, gridBagConstraints);

        updateMemoryButton.setText("Refresh");
        updateMemoryButton.setToolTipText("Update memory statistics");
        updateMemoryButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                updateMemoryButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        memoryPanel.add(updateMemoryButton, gridBagConstraints);

        jLabel5.setText("Memory Statistics:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        memoryPanel.add(jLabel5, gridBagConstraints);

        jLabel6.setText("Allocated");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        memoryPanel.add(jLabel6, gridBagConstraints);

        jLabel7.setText("Free");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        memoryPanel.add(jLabel7, gridBagConstraints);

        jLabel8.setText("Maximum");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        memoryPanel.add(jLabel8, gridBagConstraints);

        freeLabel.setText("0");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        memoryPanel.add(freeLabel, gridBagConstraints);

        allocatedLabel.setText("0");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        memoryPanel.add(allocatedLabel, gridBagConstraints);

        memStatLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        memStatLabel.setText("Memory Status");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        memoryPanel.add(memStatLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 3, 3);
        jPanel1.add(memoryPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 16, 0, 0);
        add(jPanel1, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void slideDurationTextFieldKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_slideDurationTextFieldKeyTyped
        // TODO add your handling code here:
        updateIfReturnPressed(evt, 0);
    }//GEN-LAST:event_slideDurationTextFieldKeyTyped

    private void transitionDurationTextFieldKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_transitionDurationTextFieldKeyTyped
        // TODO add your handling code here:
        updateIfReturnPressed(evt, 1);
    }//GEN-LAST:event_transitionDurationTextFieldKeyTyped

    private void transitionStepsTextFieldKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_transitionStepsTextFieldKeyTyped
        // TODO add your handling code here:
        updateIfReturnPressed(evt, 2);
    }//GEN-LAST:event_transitionStepsTextFieldKeyTyped

    private void updateButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_updateButtonMouseClicked
        // TODO add your handling code here:
        readAllEntries();
    }//GEN-LAST:event_updateButtonMouseClicked

    private void fadeEffectCheckBoxMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_fadeEffectCheckBoxMouseClicked
        // TODO add your handling code here:
        updateFadeEffect();
}//GEN-LAST:event_fadeEffectCheckBoxMouseClicked

    private void whiteBackgroundCheckBoxMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_whiteBackgroundCheckBoxMouseClicked
        // TODO add your handling code here:
        updateBlackEditBackground();
}//GEN-LAST:event_whiteBackgroundCheckBoxMouseClicked

    private void updateMemoryButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_updateMemoryButtonMouseClicked
        // TODO add your handling code here:
        updateMemStats();
    }//GEN-LAST:event_updateMemoryButtonMouseClicked

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel allocatedLabel;
    private javax.swing.JCheckBox fadeEffectCheckBox;
    private javax.swing.JLabel freeLabel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JLabel maximumLabel;
    private javax.swing.JLabel memStatLabel;
    private javax.swing.JPanel memoryPanel;
    private javax.swing.JTextField slideDurationTextField;
    private javax.swing.JPanel topInnerPanel;
    private javax.swing.JTextField transitionDurationTextField;
    private javax.swing.JTextField transitionStepsTextField;
    private javax.swing.JButton updateButton;
    private javax.swing.JButton updateMemoryButton;
    private javax.swing.JCheckBox whiteBackgroundCheckBox;
    // End of variables declaration//GEN-END:variables
}
