/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "bellthread.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/soundcard.h>


BellThread::BellThread()
        : QThread() {
    sampleRate = 44100; // samples per second
    frequency = 880; // Hz
}

BellThread::~BellThread() {}

// a rather exotic bell sound generator,
// but a similar .au file is about
// the same size as the entire program
// of which this is a part.

void BellThread::run() {
    int fd = open("/dev/dsp",O_WRONLY,0);
    setOptions(fd);
    double step = 1.0 / (double) sampleRate;
    double duration = 1.5;
    for(double t = 0;t < duration;t += step) {
        double n = sin(M_PI * frequency * t) * exp(-(t*t*8)) * envelope(0,duration,t,.01);
        int in = (int) (n * 32767);
        write(fd,&in,2);
    }
    close(fd);
}

// this envelope function smooths the transitions
// at the beginnings and endings of sound waveforms
// a = start time, b = end time, t = time
// tc = time constant for the envelope end points

double BellThread::envelope(double a,double b,double t,double tc) {
   return ((b - t) * (-a + t))/((b - t + tc) * (-a + t + tc));
}

void BellThread::setOptions(int audio) {
    int format = AFMT_S16_LE;
    ioctl(audio, SNDCTL_DSP_SETFMT, &format);
    ioctl(audio, SNDCTL_DSP_SPEED, &sampleRate);
}
