/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "comthread.h"
#include <cstdio>
#include <iostream>
#include <string>

using namespace std;

ComThread::ComThread()
        : QThread() {
    bufferLength = 512;
    buffer = new char[512];
}


ComThread::~ComThread() {
    delete(buffer);
}

void ComThread::execute(string s) {
    if(!running()) {
        comString = s;
        start();
    }
}

void ComThread::run() {
    FILE *fp = popen((comString + " 2>&1").c_str(),"r");
    string block;
    while(fgets(buffer,bufferLength,fp) != NULL) {
        block += (string) buffer + "\n";
    }
    pclose(fp);
    if(block.length() > 0) {
        error = block;
    }
}

string ComThread::getErrorMessage() {
    string s = error;
    error = "";
    return s;
}
