/***************************************************************************
 *   Copyright (C) 2004 by Paul Lutus                                      *
 *   lutusp@arachnoid.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef NETWORKCONTROL_H
#define NETWORKCONTROL_H

#include "NetworkControlGUI.h"
#include "interfacedatamanager.h"
#include "initfilehandler.h"

#include <cstdio>
#include <sys/stat.h>
#include <sys/types.h>
#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <algorithm>
#include <sys/types.h>
#include <dirent.h>
#include <qstring.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qtextedit.h>
#include <qcombobox.h>
#include <qtimer.h>
#include <qpixmap.h>
#include <qprogressbar.h>


using namespace std;

class InterfaceDataManager;
class ComThread;
class BellThread;

class NetworkControl : public MainFrame {
    Q_OBJECT

public:
    NetworkControl(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~NetworkControl();
    /*$PUBLIC_FUNCTIONS$*/
    
    InterfaceDataManager *idm;
    
    static const char *interfacePath;
    static const char *interfacePrefix;
    static const char *wirelessDataLocation;
    static const char *interfaceDataSource;
    static const char *upDownCommands[];
    
    QTimer *timer;
    
    ComThread *comthread;
    BellThread *bellthread;
    
    InitFileHandler *initHandler;
    
    string usrPath,progPath;
    
    static const string programName;
    
    static const string programVersion;
    
    static const char *iconNames[];
    static QColor textColors[]; 
    static const string stateNames[];
    static const string deltaStates[];
    QPixmap stateIcons[3];
    
    int interfaceCount;
    int timerIntervalMs;
    int *comStates,*oldStates;
    int selectionCounter;
    
    void setup();
    void closeEvent ( QCloseEvent * e );
    void setState(int,int,int);
    void startTimer();
    string strip_alias(string s);
    void showInterfaceData();
    string getInterfaceData(int,bool stripalias = false);
    int getInterfaceState(int);
    int getInterfaceState(string);
    void issueCommand(int i);
    void processWirelessData(string ifn,bool state);
    void setWirelessState(bool state);
    void paintBarValue(QProgressBar *bar,int value,string pref, double v,string suff);
    void ringBell();
    bool textIsSelected();
    void readConfigFile();
    void writeConfigFile();
    string createConfigPath();
    int readInt(MSS data,string);

public slots:
    /*$PUBLIC_SLOTS$*/
    virtual void          interfaceChange();
    virtual void          disconnectButton();
    virtual void          connectButton();
    virtual void          periodic();
    virtual void          aboutButtonPressed();

protected:
    /*$PROTECTED_FUNCTIONS$*/

protected slots:
    /*$PROTECTED_SLOTS$*/

};

#endif

