/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import opticalraytracer.LocaleHandler;
import opticalraytracer.MyColor;
import opticalraytracer.OpticalRayTracer;
import opticalraytracer.ProgramControl;

public final class ColorButton
extends JButton
implements ProgramControl {
    Color col;
    private String tag = "";
    OpticalRayTracer parent;

    public ColorButton(OpticalRayTracer p, String tag, String tip) {
        this.init(p, tag, tip);
    }

    public ColorButton(OpticalRayTracer p, String s, String tag, String tip) {
        this.col = new Color(Integer.parseInt(s));
        this.init(p, tag, tip);
    }

    public ColorButton(OpticalRayTracer p, int c, String tag, String tip) {
        this.col = new Color(c);
        this.init(p, tag, tip);
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    void init(OpticalRayTracer p, String tag, String tip) {
        this.parent = p;
        this.tag = tag;
        this.setValue(this.parent.programValues.getOneValue(tag));
        this.setToolTipText(tip);
        Dimension d = new Dimension(48, 32);
        this.setMaximumSize(d);
        this.setMinimumSize(d);
        this.setPreferredSize(d);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ColorButton.this.handleMouseClicked(evt);
            }
        });
        this.paintButton();
    }

    @Override
    public void reset() {
        int cc = Integer.parseInt(this.parent.programValues.getOneValue(this.tag));
        this.col = new MyColor(cc);
        this.paintButton();
    }

    void paintButton() {
        int rgb = this.col.getRGB();
        String hex = String.format("%06x", rgb & 0xFFFFFF);
        String str = "<html><span style=\"background:#" + hex + ";\">&nbsp;&nbsp;&nbsp;&nbsp;</html>";
        this.setText(str);
        this.parent.updateGraphicDisplay();
    }

    void handleMouseClicked(MouseEvent evt) {
        Color cc = JColorChooser.showDialog(this.parent.frame, "Choose a color", this.col);
        if (cc != null) {
            this.col = cc;
            this.parent.undoPush();
            this.parent.programValues.setOneValue(this.tag, this.getValue());
            this.paintButton();
        }
    }

    @Override
    public String getValue() {
        int ic = this.col.getBlue() & 0xFF;
        ic |= (this.col.getGreen() & 0xFF) << 8;
        ic |= (this.col.getRed() & 0xFF) << 16;
        return "" + (ic |= (this.col.getAlpha() & 0xFF) << 24);
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    @Override
    public void setValue(String s) {
        int cc = LocaleHandler.getInt(s);
        this.col = new MyColor(cc);
        this.paintButton();
    }

    public void setColor(Color c) {
        this.col = c;
        this.paintButton();
    }

    public Color getColor() {
        return this.col;
    }
}

