/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

import java.util.Date;
import opticalraytracer.Beep;
import opticalraytracer.MyColor;
import opticalraytracer.Vector;

public final class Common {
    static final double radians = Math.PI / 180;
    static final double degrees = 57.29577951308232;
    static final int OBJECT_REFRACTOR = 0;
    static final int OBJECT_REFLECTOR = 1;
    static final int OBJECT_ABSORBER = 2;
    static final String[] opticalTypes = new String[]{"Lens", "Mirror", "Absorber"};
    static final int CURVATURE_SPHERICAL = 0;
    static final int CURVATURE_PARABOLIC = 1;
    static final int CURVATURE_HYPERBOLIC = 2;
    static final int CURVATURE_PLANAR = 3;
    static final String[] curvatures = new String[]{"Spherical", "Parabolic", "Hyperbolic", "Planar"};
    static final int TAB_DESIGN = 0;
    static final int TAB_CONFIGURE = 1;
    static final int TAB_TABLE = 2;
    static final int TAB_HELP = 3;
    static int noFocusHiInt = 0xF0F0F0;
    static int noFocusLoInt = 0xA0A0A0;
    static int noFocusInverseInt = 0x202020;
    static MyColor noFocusHi = new MyColor(noFocusHiInt);
    static MyColor noFocusLo = new MyColor(noFocusLoInt);
    static MyColor noFocusInverse = new MyColor(noFocusInverseInt);

    static final void p(String s) {
        s = s.replaceAll("(\\.)(\\d{5})\\d+", "$1$2");
        Date d = new Date();
        System.out.println(d + " : " + s);
    }

    static final String pd(double v) {
        return Common.pf(v * 57.29577951308232);
    }

    static final String pf(double v) {
        return String.format("%8.4f", v);
    }

    static final String pb(boolean v) {
        return String.format("%5s", "" + v);
    }

    static final void pr(String s) {
        s = s.replaceAll("(\\.)(\\d{3})\\d+", "$1$2");
        System.out.println(s);
    }

    static final String getObjectType(int function) {
        return opticalTypes[function];
    }

    static final Vector computeReflectionAngle(Vector via, Vector vsa) {
        return via.sub(vsa.mul(via.dot(vsa)).mul(2.0));
    }

    static final double ntrp(double x, double xa, double xb, double ya, double yb) {
        return (x - xa) / (xb - xa) * (yb - ya) + ya;
    }

    static final void beep() {
        Beep.beep();
    }

    static final boolean inBounds(double x, double y, double x1, double y1, double x2, double y2) {
        if (x1 != x2) {
            return x1 <= x && x <= x2 || x2 <= x && x <= x1;
        }
        return y1 <= y && y <= y2 || y2 <= y && y <= y1;
    }

    static final String wrapTag(String tag, String data, String also, boolean linefeeds) {
        if (linefeeds) {
            return String.format("<%s %s>\n%s\n</%s>\n", tag, also, data, tag);
        }
        return String.format("<%s %s>%s</%s>", tag, also, data, tag);
    }

    static final double sign(double v) {
        return v < 0.0 ? -1 : 1;
    }

    static final double distanceToLine(double x, double y, double x1, double y1, double x2, double y2) {
        return Math.abs(-(x1 - x2) * y + x * (y1 - y2) - x2 * y1 + x1 * y2) / Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    static final double xCoordinateOnLine(double x, double y, double x1, double y1, double x2, double y2) {
        return ((x * (x1 - x2) + y * (y1 - y2)) * (x1 - x2) + (x2 * y1 - x1 * y2) * (y1 - y2)) / (Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    static final double yCoordinateOnLine(double x, double y, double x1, double y1, double x2, double y2) {
        return -((x2 * y1 - x1 * y2) * (x1 - x2) - (x * (x1 - x2) + y * (y1 - y2)) * (y1 - y2)) / (Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    static final int linesIntersect(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double divisor = (x3 - x4) * (y1 - y2) - (x1 - x2) * (y3 - y4);
        if (divisor == 0.0 || Double.isNaN(divisor)) {
            return -1;
        }
        double x = -((x4 * y3 - x3 * y4) * (x1 - x2) - (x2 * y1 - x1 * y2) * (x3 - x4)) / divisor;
        double y = -((x4 * y3 - x3 * y4) * (y1 - y2) - (x2 * y1 - x1 * y2) * (y3 - y4)) / divisor;
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return -1;
        }
        return Common.inBounds(x, y, x1, y1, x2, y2) && Common.inBounds(x, y, x3, y3, x4, y4) ? 1 : 0;
    }

    static final double distanceToParallelLine(Vector a, Vector b, Vector p) {
        double ly;
        double lx = Common.xCoordinateOnLine(p.x, p.y, a.x, a.y, b.x, b.y);
        if (Common.inBounds(lx, ly = Common.yCoordinateOnLine(p.x, p.y, a.x, a.y, b.x, b.y), a.x, a.y, b.x, b.y)) {
            return Common.distanceToLine(p.x, p.y, a.x, a.y, b.x, b.y);
        }
        return Double.NaN;
    }

    static final double snell(double a1, double n1, double n2) {
        return Math.asin(Math.sin(a1) * n1 / n2);
    }

    static final double snell2d(double a1, double a2, double n1, double n2) {
        Vector i = Vector.polar(a1);
        Vector n = Vector.polar(-1.0, a2);
        return Common.snell2d(i, n, n1, n2).angle();
    }

    static final Vector snell2d(Vector i, Vector n, double n1, double n2) {
        double c1 = -n.dot(i);
        if (c1 < 0.0) {
            c1 = -c1;
            n = n.negate();
        }
        double r = n1 / n2;
        double c2 = Math.sqrt(1.0 - r * r * (1.0 - c1 * c1));
        return i.mul(r).add(n.mul(r * c1 - c2));
    }
}

