/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import opticalraytracer.DataTableCellRenderer;
import opticalraytracer.LineData;
import opticalraytracer.OpticalRayTracer;

public final class DataTableModel
extends AbstractTableModel {
    OpticalRayTracer parent;
    ArrayList<ArrayList<String>> array;
    String[] header;
    int[] columnWidths;
    boolean[] rightJust;
    JTable table;
    FontMetrics fm;

    public DataTableModel(OpticalRayTracer p, JTable table) {
        this.parent = p;
        this.table = table;
        JTableHeader hd = table.getTableHeader();
        hd.setBackground(new Color(0xC0D0C0));
        hd.setFont(new Font("Arial", 1, 12));
        this.fm = table.getFontMetrics(table.getFont());
        this.array = new ArrayList();
        this.header = this.parent.lineAnalysis.header;
        this.columnWidths = new int[this.header.length];
        this.rightJust = new boolean[this.header.length];
    }

    protected boolean getRightJust(int i) {
        boolean result = false;
        if (i >= 0 && i < this.rightJust.length) {
            result = this.rightJust[i];
        }
        return result;
    }

    protected String padString(String s) {
        return " " + s + " ";
    }

    protected ArrayList<String> makeRow(LineData ld) {
        ArrayList<String> row = new ArrayList<String>();
        row.add(this.padString(ld.fromEvent));
        row.add(this.padString(ld.toEvent));
        row.add(this.padString(ld.from));
        row.add(this.padString(ld.to));
        row.add(this.padString(ld.type));
        double[] dArray = ld.numericValues();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            row.add(this.padString(this.parent.formatNum(v)));
            ++n2;
        }
        return row;
    }

    protected void updateDisplay() {
        if (this.parent.rayTraceComputer != null) {
            this.parent.rayTraceComputer.traceRays(null, true);
            if (this.parent.rayTraceComputer.lineList != null && this.parent.rayTraceComputer.lineList.size() > 0) {
                int limit = this.parent.programValues.tableLineLimit;
                int len = this.parent.rayTraceComputer.lineList.size();
                int top = len > limit ? limit : len;
                String s = "Displaying " + top + " of " + len + " lines";
                if (this.parent.tableDataLabel != null) {
                    this.parent.tableDataLabel.setText(s);
                }
                this.array.clear();
                int marg = 8;
                int cw = this.fm.stringWidth("X");
                int n = 0;
                while (n < this.columnWidths.length) {
                    this.columnWidths[n] = this.header[n].length() * cw + marg;
                    ++n;
                }
                int lines = 0;
                for (LineData ld : this.parent.rayTraceComputer.lineList) {
                    ArrayList<String> row = this.makeRow(ld);
                    int n2 = 0;
                    while (n2 < row.size()) {
                        String ss = row.get(n2);
                        this.columnWidths[n2] = Math.max(ss.length() * cw + marg, this.columnWidths[n2]);
                        ++n2;
                    }
                    this.array.add(row);
                    if (++lines > limit) break;
                }
                int ch = this.fm.getHeight();
                int n3 = 0;
                while (n3 < this.getColumnCount()) {
                    this.table.getColumnModel().getColumn(n3).setMinWidth(this.columnWidths[n3]);
                    DataTableCellRenderer rr = new DataTableCellRenderer(this.rightJust);
                    this.table.getColumnModel().getColumn(n3).setCellRenderer(rr);
                    ++n3;
                }
                n3 = 0;
                while (n3 < this.getColumnCount()) {
                    String ts = this.array.get(0).get(n3);
                    this.rightJust[n3] = !ts.matches(".*[A-Z].*");
                    ++n3;
                }
                this.table.setRowHeight(ch + 8);
            }
        }
    }

    protected LineData getRowData(int row) {
        LineData result = null;
        if (this.parent.rayTraceComputer.lineList != null && row >= 0 && row <= this.parent.rayTraceComputer.lineList.size()) {
            result = this.parent.rayTraceComputer.lineList.get(row);
        }
        return result;
    }

    @Override
    public String getColumnName(int column) {
        return this.header[column];
    }

    @Override
    public int getRowCount() {
        return this.array.size();
    }

    @Override
    public int getColumnCount() {
        return this.header.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.array.get(rowIndex).get(columnIndex);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

