/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

import java.util.ArrayList;
import java.util.Iterator;
import opticalraytracer.ElementBase;
import opticalraytracer.OpticalComponent;
import opticalraytracer.OpticalRayTracer;
import opticalraytracer.Vector;

public final class ElementParabolic
implements ElementBase {
    OpticalRayTracer parent;
    private double srValue = -1.0;
    private double lrValue = -1.0;
    private double mValue = -1.0;
    private double bValue = -1.0;
    double leftMax;
    double rightMax;
    private ArrayList<Vector> points;
    private int pointsSize = 8;
    private double epsilon = 1.0E-6;

    public ElementParabolic(OpticalRayTracer p) {
        this.parent = p;
        this.points = new ArrayList();
        int i = 0;
        while (i < this.pointsSize) {
            this.points.add(new Vector());
            ++i;
        }
    }

    @Override
    public ArrayList<Vector> getPoints() {
        return this.points;
    }

    private double pa0(double s, double x_1, double y_1) {
        return (-2.0 * s * y_1 - Math.sqrt(4.0 * (s * s) * x_1 - 4.0 * s * y_1 + 1.0) + 1.0) / (2.0 * (s * s));
    }

    private double pa1(double s, double x_1, double y_1) {
        return (-2.0 * s * y_1 - Math.sqrt(4.0 * (s * s) * x_1 - 4.0 * s * y_1 + 1.0) + 1.0) / (2.0 * s);
    }

    private double pa2(double s, double x_1, double y_1) {
        return (-2.0 * s * y_1 + Math.sqrt(4.0 * (s * s) * x_1 - 4.0 * s * y_1 + 1.0) + 1.0) / (2.0 * (s * s));
    }

    private double pa3(double s, double x_1, double y_1) {
        return (-2.0 * s * y_1 + Math.sqrt(4.0 * (s * s) * x_1 - 4.0 * s * y_1 + 1.0) + 1.0) / (2.0 * s);
    }

    private double pa4(double s, double x_1, double y_1) {
        return -(2.0 * s * y_1 + Math.sqrt(-4.0 * (s * s) * x_1 + 4.0 * s * y_1 + 1.0) + 1.0) / (2.0 * (s * s));
    }

    private double pa5(double s, double x_1, double y_1) {
        return -(2.0 * s * y_1 + Math.sqrt(-4.0 * (s * s) * x_1 + 4.0 * s * y_1 + 1.0) + 1.0) / (2.0 * s);
    }

    private double pa6(double s, double x_1, double y_1) {
        return (-2.0 * s * y_1 + Math.sqrt(-4.0 * (s * s) * x_1 + 4.0 * s * y_1 + 1.0) - 1.0) / (2.0 * (s * s));
    }

    private double pa7(double s, double x_1, double y_1) {
        return (-2.0 * s * y_1 + Math.sqrt(-4.0 * (s * s) * x_1 + 4.0 * s * y_1 + 1.0) - 1.0) / (2.0 * s);
    }

    private double pb(double y, double x_1, double y_1) {
        return -x_1 + (y + y_1) * (y + y_1);
    }

    private double pd(double y, double y_1) {
        return 2.0 * y + 2.0 * y_1;
    }

    @Override
    public void intersections(OpticalComponent oc, boolean leftSide, Vector op1, Vector op2) {
        double s;
        Vector p1;
        Vector tc;
        for (Vector p : this.points) {
            p.assign(Vector.invalidState());
        }
        double signedScale = oc.signedScale(leftSide);
        double lensRadius = oc.lensRadius();
        double angleRadians = oc.angleRadians();
        while (true) {
            Vector thr = new Vector(-oc.signedThickness(leftSide), 0.0).rotate(angleRadians);
            tc = new Vector(oc.xPos(), oc.yPos()).translate(thr);
            p1 = new Vector(op1).translateSub(tc).rotate(-angleRadians).scale(1.0 / signedScale, 1.0 / lensRadius);
            Vector p2 = new Vector(op2).translateSub(tc).rotate(-angleRadians).scale(1.0 / signedScale, 1.0 / lensRadius);
            s = (p2.y - p1.y) / (p2.x - p1.x);
            if (Math.abs(s) >= this.epsilon) break;
            angleRadians += this.epsilon;
        }
        this.updateFactors(oc, leftSide);
        int n = 0;
        int len_d2 = this.points.size() / 2;
        Iterator<Vector> ic = this.points.iterator();
        double sb = -1.0;
        while (ic.hasNext()) {
            double sbb = n < len_d2 ? -sb : sb;
            Vector pt = ic.next();
            pt.x = this.pa0(s, p1.x - sbb, p1.y) + p1.x;
            pt.y = this.pa1(s, p1.x - sbb, p1.y) + p1.y;
            pt = ic.next();
            pt.x = this.pa2(s, p1.x + sbb, p1.y) + p1.x;
            pt.y = this.pa3(s, p1.x + sbb, p1.y) + p1.y;
            pt = ic.next();
            pt.x = this.pa4(s, p1.x - sbb, p1.y) + p1.x;
            pt.y = this.pa5(s, p1.x - sbb, p1.y) + p1.y;
            pt = ic.next();
            pt.x = this.pa6(s, p1.x + sbb, p1.y) + p1.x;
            pt.y = this.pa7(s, p1.x + sbb, p1.y) + p1.y;
            n += 4;
        }
        double slmaxx = this.leftMax * 2.0 / Math.abs(signedScale);
        double srmaxx = this.rightMax * 2.0 / Math.abs(signedScale);
        double count = 0.0;
        double minx = 1000000.0;
        double maxx = -1000000.0;
        for (Vector p : this.points) {
            if (leftSide) {
                p.x = p.x < 0.0 ? Double.NaN : p.x;
                p.x = p.x > slmaxx ? Double.NaN : p.x;
            } else {
                p.x = p.x > 0.0 ? Double.NaN : p.x;
                double d = p.x = p.x < -srmaxx ? Double.NaN : p.x;
            }
            if (Double.isNaN(p.x)) continue;
            minx = Math.min(minx, p.x);
            maxx = Math.max(maxx, p.x);
            count += 1.0;
        }
        if (!oc.isReflector() && count > 1.0) {
            for (Vector p : this.points) {
                if (p.x < 0.0) {
                    p.x = p.x == minx ? Double.NaN : p.x;
                    continue;
                }
                double d = p.x = p.x == maxx ? Double.NaN : p.x;
            }
        }
        for (Vector p : this.points) {
            p.assign(p.scale(signedScale, lensRadius).rotate(angleRadians).translate(tc));
        }
    }

    @Override
    public double lensProfileXforY(OpticalComponent oc, boolean leftSide, double y, double cx) {
        this.updateFactors(oc, leftSide);
        return this.lensProfileXforYCore(oc, leftSide, y, cx);
    }

    private double lensProfileXforYCore(OpticalComponent oc, boolean leftSide, double y, double cx) {
        double x = this.pb(y, cx + this.bValue, 0.0) * this.mValue * oc.scale(leftSide) * oc.radiusSign(leftSide) - oc.thickness();
        if (leftSide) {
            x = -x;
        }
        return x;
    }

    @Override
    public double lensProfileDXforY(OpticalComponent oc, boolean leftSide, boolean entering, double y) {
        this.updateFactors(oc, leftSide);
        double dx = this.pd(y, 0.0) * this.mValue * oc.scale(leftSide) * oc.radiusSign(leftSide);
        if (leftSide) {
            dx = -dx;
        }
        return dx;
    }

    private void updateFactors(OpticalComponent oc, boolean leftSide) {
        double newSR = oc.sphereRadius(leftSide);
        double newLR = oc.lensRadius();
        if (this.srValue != newSR || this.lrValue != newLR) {
            this.mValue = 1.0 / (newLR * newLR);
            this.bValue = this.pb(newLR, 0.0, 0.0);
            this.srValue = newSR;
            this.lrValue = newLR;
            double a = Math.abs(this.lensProfileXforYCore(oc, true, 0.0, 0.0));
            double b = Math.abs(this.lensProfileXforYCore(oc, true, newLR, 0.0));
            this.leftMax = Math.max(a, b);
            a = Math.abs(this.lensProfileXforYCore(oc, false, 0.0, 0.0));
            b = Math.abs(this.lensProfileXforYCore(oc, false, newLR, 0.0));
            this.rightMax = Math.max(a, b);
        }
    }
}

