/*
 * Decompiled with CFR 0.152.
 */
package opticalraytracer;

import java.util.ArrayList;
import opticalraytracer.Common;
import opticalraytracer.ElementBase;
import opticalraytracer.OpticalComponent;
import opticalraytracer.OpticalRayTracer;
import opticalraytracer.Vector;

public final class ElementPlanar
implements ElementBase {
    OpticalRayTracer parent;
    private ArrayList<Vector> points;
    Vector pt;

    public ElementPlanar(OpticalRayTracer p) {
        this.parent = p;
        this.points = new ArrayList();
        this.pt = new Vector();
        this.points.add(this.pt);
    }

    @Override
    public void intersections(OpticalComponent oc, boolean leftSide, Vector op1, Vector op2) {
        double angleRadians = oc.angleRadians();
        Vector thr = new Vector(-oc.signedThickness(leftSide), 0.0).rotate(angleRadians);
        Vector tc = new Vector(oc.xPos(), oc.yPos()).translate(thr);
        Vector p1 = new Vector(op1).translateSub(tc).rotate(-angleRadians);
        Vector p2 = new Vector(op2).translateSub(tc).rotate(-angleRadians);
        this.pt.x = 0.0;
        this.pt.y = Common.ntrp(this.pt.x, p1.x, p2.x, p1.y, p2.y);
        this.pt.assign(this.pt.rotate(angleRadians).translate(tc));
    }

    @Override
    public double lensProfileXforY(OpticalComponent oc, boolean leftSide, double y, double cx) {
        double x = leftSide ? oc.thickness() : -oc.thickness();
        return x + y * 1.0E-9;
    }

    @Override
    public double lensProfileDXforY(OpticalComponent oc, boolean leftSide, boolean entering, double y) {
        return 0.0;
    }

    @Override
    public ArrayList<Vector> getPoints() {
        return this.points;
    }
}

